# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: lxqt-session
Version: 2.2.0
Release: alt1

Summary: Session manager
License: LGPL-2.1
Group: Graphical desktop/Other

Url: https://github.com/lxqt/lxqt-session
Source0: %name-%version.tar
Source1: 08lxqt
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ cmake rpm-macros-cmake git-core
BuildRequires: lxqt2-build-tools
BuildRequires: liblxqt-devel >= 2.0.0
BuildRequires: qt6-base-devel qt6-tools-devel
BuildRequires: qtxdg-tools-devel >= 4.0.0
BuildRequires: kf6-kwindowsystem-devel
BuildRequires: libqt6xdg-devel
BuildRequires: rpm-build-xdg xdg-utils xdg-user-dirs
BuildRequires: plasma6-layer-shell-qt-devel
BuildRequires: libudev-devel
BuildRequires: libproc2-devel

Requires: lxqt-themes
Requires: xdg-utils
Requires: qtxdg-tools >= 4.0.0

Provides: razorqt-session = %version
Obsoletes: razorqt-session < 0.7.0

Conflicts: lxqt-common <= 0.11.0

%description
%summary.

%prep
%setup
%autopatch -p1

# https://bugzilla.altlinux.org/32657
sed -i 's,Exec=,Exec=%_bindir/,' xsession/lxqt.desktop.in

%build
%add_optflags -I%_includedir/KF6/ -L%_libdir/kf6/devel/
%cmake -DPULL_TRANSLATIONS=OFF \
       -DUPDATE_TRANSLATIONS=OFF \
       -DBUNDLE_XDG_UTILS=No
%cmake_build

%install
%cmake_install
install -pDm644 %SOURCE1 %buildroot%_sysconfdir/X11/wmsession.d/08lxqt

%files
%_man1dir/*
%_bindir/*
%_xdgconfigdir/autostart/lxqt-xscreensaver-autostart.desktop
%_desktopdir/*.desktop
%_datadir/xsessions/*.desktop
%_datadir/lxqt/*
%_sysconfdir/X11/wmsession.d/08lxqt
%doc AUTHORS CHANGELOG LICENSE README.md

%changelog
