# Unbundling helper macro
# 1st arg is the path to dir bundling files (from)
# 2nd arg is the path to dir containing original files (with)
%global unbundle_from_with() \
  bundled_dir="%1" \
  bundled_files="$(find "${bundled_dir}" -maxdepth 1 -type f -printf '%f\\n')" \
  original_dir="%2" \
  for file in ${bundled_files} \
  do \
    if [ -f "${original_dir}/${file}" ] \
    then \
      rm -f "${bundled_dir}/${file}" \
      ln -s "${original_dir}/${file}" "${bundled_dir}/${file}" \
    fi \
  done

%global unbundle_font_latex_xft       1

Name: lyx
Version: 2.3.7
Release: alt1.2

Summary: LyX - a WYSIWYM word processor for the Desktop Environment.
# LGPL-2.1+: src/support/gzstream.* src/support/weighted_btree.h
License: %gpl2only and %lgpl21plus
Group: Publishing
Epoch: 2
Url: http://www.lyx.org

Source: %name-%version.tar
Source1: %name.desktop
Source2: %{name}16.xpm
Source3: %{name}32.xpm
Source4: %{name}48.xpm
Source5: lyxcat

Patch0: lyx-2.1.2-xdg_open.patch
Patch1: 0004-Use-python3-internally-in-the-C-code-as-well.patch
Patch2: lyx-2.3.6.1-python.patch

BuildRequires(pre): rpm-build-licenses

BuildRequires: desktop-file-utils
BuildRequires: gcc-c++ imake libaspell-devel libSM-devel python3-devel bc
BuildRequires: libaiksaurus-devel boost-signals-devel boost-devel boost-filesystem-devel
BuildRequires: qt5-base-devel qt5-x11extras-devel qt5-svg-devel
BuildRequires: zlib-devel libenchant-devel libhunspell-devel libmythes-devel

Provides: lyx-common lyx-qt lyx-latex-beamer
Obsoletes: lyx-common lyx-qt lyx-latex-beamer

%if %unbundle_font_latex_xft
BuildRequires: fonts-ttf-latex-xft
Requires: fonts-ttf-latex-xft
%filter_from_requires /\/usr\/share\/fonts\/ttf\/latex\-xft.*/d
%endif

%description
LyX is a modern approach to writing documents which breaks with the
obsolete "typewriter paradigm" of most other document preparation
systems.

It is designed for people who want professional quality output
with a minimum of time and effort, without becoming specialists in
typesetting.

The major innovation in LyX is WYSIWYM (What You See Is What You Mean).
That is, the author focuses on content, not on the details of
formatting.
This allows for greater productivity, and leaves the final typesetting
to the backends (like LaTeX) that are specifically designed
for the task.

With LyX, the author can concentrate on the contents of his writing,
and let the computer take care of the rest.

%package -n lyx-tex
Summary: Virtual package that install required set of tex packages for LyX.
Group: Publishing
Requires: lyx
Requires: texlive-latex-recommended texlive-extra texlive-lang-cyrillic texlive-fonts-recommended fonts-ttf-latex-xft 
BuildArch: noarch

%description -n lyx-tex
Virtual package that install required set of tex packages for LyX.

%prep
%setup
find 3rdparty -not -type d -not -name Makefile.in -delete
find lib \( -name '*.py' -or -name '*.py.in' \) \
	-execdir sed -i '1i #!/usr/bin/python3' {} \+
sed -i 's|#! */usr/bin/env python|#!/usr/bin/env python3|' \
	lib/lyx2lyx/lyx2lyx \
	lib/scripts/listerrors \
	#
%autopatch -p1
%ifarch %e2k
# because of the incorrect C++ code in this project and a missing optimization in the compiler for e2k
# this helps the compiler to perform this optimization
sed -E -i 's/zoom_m(in|ax)_/(int)&/g' src/frontends/qt4/GuiView.cpp
%endif

%build
%autoreconf
export PYTHON=python3
%configure \
	--without-included-boost \
	--with-enchant \
	--with-hunspell \
	--enable-qt5 \
	#

%make_build

%install
%makeinstall_std
%find_lang %name

# Unbundle fonts from fonts/
# latex-xft
%if %unbundle_font_latex_xft
%unbundle_from_with %buildroot%_datadir/%name/fonts %_datadir/fonts/ttf/latex-xft
%endif

# This one is optional and python2-only.
rm %buildroot%_datadir/%name/lyx2lyx/profiling.py

install -d -m 755 %buildroot%_desktopdir
install -m 644 %SOURCE1 %buildroot%_desktopdir/
install -d -m 755 %buildroot%_miconsdir
install -d -m 755 %buildroot%_niconsdir
install -d -m 755 %buildroot%_liconsdir
install -m 644 %SOURCE2 %buildroot%_miconsdir/%name.xpm
install -m 644 %SOURCE3 %buildroot%_niconsdir/%name.xpm
install -m 644 %SOURCE4 %buildroot%_liconsdir/%name.xpm
install -m 755 %SOURCE5 %buildroot%_bindir/

#
# Set up the lyx-specific class files where TeX can see then
#
TEXMF=%_datadir/texmf
mkdir -p %buildroot$TEXMF/tex/latex
cp -ar %buildroot%_datadir/%name/tex %buildroot$TEXMF/tex/latex/%name

desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Office:WordProcessor:KDE:Qt \
	--add-category=Office \
	--add-category=WordProcessor \
	--add-category=KDE \
	--add-category=Qt \
	%buildroot%_desktopdir/lyx.desktop

rm %buildroot%_datadir/icons/hicolor/scalable/apps/lyx.svg
rm %buildroot%_datadir/%name/scripts/prefTest.pl.in

# something what configure.py generates
touch %buildroot%_datadir/%name/{bbx,bib,bst,cbx,cls,sty}Files.lst
touch %buildroot%_datadir/%name/{lyxciteengines,lyxmodules,packages,textclass,xtemplates}.lst
touch %buildroot%_datadir/%name/configure.log
touch %buildroot%_datadir/%name/lyxrc.defaults
mkdir %buildroot%_datadir/%name/clipart

%define _unpackaged_files_terminate_build 1

%post
# configure Lyx in new way
cd %_datadir/%name
python3 configure.py

%files -f %name.lang
%doc ANNOUNCE COPYING INSTALL* README* NEWS UPGRADING RELEASE-NOTES
%_bindir/*
%_man1dir/*
%_datadir/%name
%_datadir/texmf/tex/latex/lyx
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_desktopdir/*.desktop
%ghost %_datadir/%name/clipart
%ghost %_datadir/%name/*.lst
%ghost %_datadir/%name/configure.log
%ghost %_datadir/%name/lyxrc.defaults

%files -n lyx-tex

%changelog
