Summary: Tools for searching and reading man pages
Name: man-db
Version: 2.13.0
Release: alt1
# GPLv2+ .. man-db
# GPLv3+ .. gnulib
License: GPL-2.0-or-later and GPL-3.0-or-later
Group: System/Base
URL: https://gitlab.com/cjwatson/man-db

Source0: %name-%version.tar

Patch0001: 0001-Change-owner-of-man-cache.patch
Patch0003: 0003-catman-Use-PATH-env.patch
Patch0004: 0004-Implemented-in-process-lzma-decompression.patch
Patch0006: 0005-Update-Russian-manual-page-translation.patch

Obsoletes: man < 2.0
Obsoletes: man-whatis < 2.0
Provides: man-whatis = %version

Provides: man = %version
Provides: man-pages-reader = %version

# previous versions of the package contain the files: apropos.1, man.1, whatis.1
Conflicts: man-pages-ru-extra < 0.1-alt5

Requires: coreutils, grep, groff-base, gzip, less, xz

BuildRequires: flex
BuildRequires: gdbm-devel
BuildRequires: gettext
BuildRequires: gnulib
BuildRequires: groff-base groff-ps
BuildRequires: less
BuildRequires: perl
BuildRequires: pkgconfig(liblzma)
BuildRequires: pkgconfig(libpipeline)
BuildRequires: pkgconfig(zlib)
BuildRequires: po4a
BuildRequires: xz

%description
The man-db package includes five tools for browsing man-pages:
man, whatis, apropos, manpath and lexgrog. man formats and displays
manual pages. whatis searches the manual page names. apropos searches the
manual page names and descriptions. manpath determines search path
for manual pages. lexgrog directly reads header information in
manual pages.

%package cron
Summary: Periodic update of man-db cache
Group: System/Base

Requires: %name = %version-%release
Requires: crontabs

BuildArch: noarch

%description cron
This package provides periodic update of man-db cache.

%global cache /var/cache/man
%define _unpackaged_files_terminate_build 1

%prep
%setup
%autopatch -p1
%ifarch %e2k
sed -E -i "s|(MANDATORY_MANPATH\t*)/usr/local/share/man|&\n\\1/opt/mcst/man|" src/man_db.conf.in
%endif

%build
./bootstrap \
	--gnulib-srcdir=%_datadir/gnulib \
	--no-git \
	--skip-po

%autoreconf
%configure \
    --with-systemdtmpfilesdir=%_tmpfilesdir \
    --with-systemdsystemunitdir=no \
    --with-sections="1 1p 8 2 3 3p 4 5 6 7 9 0p n l p o 1x 2x 3x 4x 5x 6x 7x 8x" \
    --disable-setuid \
    --enable-cache-owner=root \
    --with-browser=elinks \
    --with-lzip=lzip \
    --with-xz=xz \
    --with-override-dir=overrides

%make CC="%__cc %optflags" %{?_smp_mflags} V=1

%check
%make check

%install
%make install \
	INSTALL='install -p' \
	DESTDIR=%buildroot \
	prefix=%_prefix

# move the documentation to the relevant place
mv %buildroot%_datadir/doc/man-db/* ./

# remove zsoelim man page - part of groff package
rm %buildroot%_man1dir/zsoelim.1

# remove libtool archives
rm %buildroot%_libdir/man-db/*.la

# install cache directory
install -d -m 0755  %buildroot/%cache

# install cron script for man-db creation/update
mkdir -p %buildroot%_sysconfdir/cron.daily
install -Dp -m 0755 .rpm/man-db.crondaily \
	%buildroot%_sysconfdir/cron.daily/man-db.cron

# config for cron script
mkdir -p %buildroot%_sysconfdir/sysconfig
install -Dp -m 0644 .rpm/man-db.sysconfig \
	%buildroot%_sysconfdir/sysconfig/man-db

# install filetrigger
mkdir -p %buildroot%_rpmlibdir
install -Dp -m 0755 .rpm/man-db.filetrigger \
	%buildroot%_rpmlibdir/man-db.filetrigger

(
    cd %buildroot
    find .%_datadir/man -mindepth 1 -maxdepth 1 ! -name 'man*' -printf '%%%%lang(%%f) %%p/man*/*\n' |
        sed -e 's, \./, /,'
) > %name.files

%find_lang %name
%find_lang %name-gnulib

cat %name.lang %name-gnulib.lang >> %name.files

# clear the old cache
%post
rm -rf -- %cache/*

%files -f %name.files
%doc README.md NEWS.md
%config(noreplace) %_sysconfdir/man_db.conf
%config(noreplace) %_tmpfilesdir/man-db.conf
%config(noreplace) %_sysconfdir/sysconfig/man-db
%_sbindir/*
%_bindir/*
%_libdir/man-db
%_libexecdir/man-db
%_rpmlibdir/man-db.filetrigger
%attr(2755,root,man) %verify(not mtime) %dir %cache
%_man1dir/*.1*
%_man5dir/*.5*
%_man8dir/*.8*

%files cron
%config(noreplace) %_sysconfdir/cron.daily/man-db.cron

%changelog
