%define rname marble

%define marblewidget_sover 28
%define libmarblewidget libmarblewidget-qt6_%marblewidget_sover

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%ifarch %qt6_qtwebengine_arches
%def_enable qtwebengine
%else
%def_disable qtwebengine
%endif

Name: %rname
Version: 25.04.3
Release: alt1
%K6init

Group: Education
Summary: A virtual globe and world atlas
Url: http://www.kde.org
License: LGPL-2.1-or-later

Provides:  kde5-marble = %EVR
Obsoletes: kde5-marble < %EVR

Source: %rname-%version.tar
Source2: naturalearth.tar
Patch1: alt-astro-static.patch
Patch2: alt-remove-country-data.patch

BuildRequires(pre): rpm-build-kf6 rpm-macros-qt6-webengine
BuildRequires: extra-cmake-modules qt6-declarative-devel qt6-positioning-devel qt6-svg-devel qt6-tools-devel qt6-serialport-devel qt6-5compat-devel
BuildRequires: libvulkan-devel
%if_enabled qtwebengine
BuildRequires: qt6-webengine-devel
%endif
BuildRequires: qt6-phonon-devel
#BuildRequires: libwlocate-devel
BuildRequires: libabseil-cpp-devel
BuildRequires: libgps-devel libshape-devel zlib-devel libprotobuf-devel protobuf-compiler
BuildRequires: kf6-kauth-devel kf6-kbookmarks-devel kf6-kcodecs-devel kf6-kcompletion-devel kf6-kconfig-devel
BuildRequires: kf6-kconfigwidgets-devel kf6-kcoreaddons-devel kf6-kcrash-devel kf6-kdoctools kf6-kdoctools-devel
BuildRequires: kf6-ki18n-devel kf6-kio-devel kf6-kitemviews-devel kf6-kjobwidgets-devel kf6-knewstuff-devel kf6-kpackage-devel
BuildRequires: kf6-kparts-devel kf6-krunner-devel kf6-kservice-devel kf6-ktextwidgets-devel kf6-kwallet-devel kf6-kwidgetsaddons-devel
BuildRequires: kf6-kxmlgui-devel kf6-solid-devel kf6-sonnet-devel
BuildRequires: plasma6-lib-devel

%description
Marble is a Virtual Globe and World Atlas that you can use to learn more
about Earth: You can pan and zoom around and you can look up places and
roads. A mouse click on a place label will provide the respective
Wikipedia article.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf6-filesystem
Provides:  kde5-marble-common = %EVR
Obsoletes: kde5-marble-common < %EVR
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package addon-maps
Group: Education
Summary: Additional maps for %name
Requires: %name
Conflicts: kde5-marble < 6
%description addon-maps
Additional maps for %name.

%package -n %libmarblewidget
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
Obsoletes: libmarblewidget-qt528 < %EVR
%description -n %libmarblewidget
%name library


%prep
%setup -n %rname-%version
rm -fv data/naturalearth/*.pn2
pushd data/
tar -xvf %SOURCE2 naturalearth/
popd
%patch1 -p1
%patch2 -p1
sed -i '/add_subdirectory(marble-qt)/d' src/apps/CMakeLists.txt

# disable krunners by default
for f in \
src/plasmarunner/plasma-runner-marble.json
do
    sed -i '/EnabledByDefault/s|true|false|' $f
done

%build
%K6build \
    -DKDE_INSTALL_INCLUDEDIR=%_K6inc \
    -DKDE_INSTALL_CONFDIR=%_K6xdgconf \
    -DBUILD_MARBLE_TOOLS=YES \
    -DBUILD_MARBLE_EXAMPLES=NO \
    -DMARBLE_DATA_PATH=%_K6data/marble \
    -DMARBLE_PRI_INSTALL_USE_QT_SYS_PATHS=YES \
    #


%install
%K6install
%K6install_move data marble config.kcfg icons knsrcfiles

# hide service files
for f in %buildroot/%_K6xdgapp/*_thumbnail_*.desktop ; do
    LC_ALL=en_US.UTF-8 desktop-file-install \
	--dir %buildroot/%_K6xdgapp \
	--set-key="NoDisplay" \
	--set-value="true" \
	$f ||:
done

mv %buildroot/%_K6xdgmime/geo{,-kde6}.xml

if [ "%_desktopdir" != "%_K6xdgapp" ] ;then
    mkdir -p %buildroot/%_K6xdgapp
    mv %buildroot/%_desktopdir/*.desktop %buildroot/%_K6xdgapp/ ||:
fi
if [ "%_includedir" != "%_K6inc" ] ;then
    mkdir -p %buildroot/%_K6inc
    mv %buildroot/%_includedir/marble %buildroot/%_K6inc/ ||:
fi


rm -rf %buildroot/%_datadir/locale/*/LC_MESSAGES/*_qt.qm
rm -rf %buildroot/%_K6i18n/*/LC_MESSAGES/*_qt.qm
%find_lang %name --with-kde --all-name

%files common -f %name.lang
%doc LICENSES/*
%_K6cfg/marble.kcfg
%_K6xdgmime/geo-kde6.xml

%files
#%_K6lib/libmarbledeclarative.so
%_K6bin/marble*
%_K6plug/*marble*.so
%_K6plug/kf6/krunner/*marble*.so
%_K6data/plasma/plasmoids/org.kde.plasma.worldclock/
%_K6data/plasma//wallpapers/org.kde.plasma.worldmap/
%_K6lib/marble/
%_K6qml/org/kde/marble/
#%_K6srv/*.desktop
%_K6xdgapp/*marble*.desktop
%_K6icon/*/*/apps/*marble*.*
%_K6data/kxmlgui?/marble/
%_datadir/metainfo/*.xml
%_datadir/qlogging-categories?/*.*categories
%_K6data/marble/
%exclude %_K6data/marble/maps/earth/openstreetmap/
%exclude %_K6data/marble/maps/earth/vectorosm/
%exclude %_K6data/marble/maps/earth/political/

%files addon-maps
%_K6data/marble/maps/earth/openstreetmap/
%_K6data/marble/maps/earth/vectorosm/
%_K6data/marble/maps/earth/political/

%files devel
#%_K6plug/designer/*.so
#%_K6inc/astro/
%_K6inc/marble/
%_K6link/lib*.so
%_K6lib/cmake/Marble/
%_K6archdata/mkspecs/modules/qt_Marble.pri

%files -n %libmarblewidget
%_K6lib/libmarblewidget-qt6.so.%marblewidget_sover
%_K6lib/libmarblewidget-qt6.so.*

%changelog
