Name: mdds
Version: 2.1.1
Release: alt1
Summary: A collection of multi-dimensional data structures and indexing algorithms

Group: Development/C++
License: MIT
Url: https://gitlab.com/mdds/mdds
# http://kohei.us/files/%%name/src/%%name-%%version.tar.bz2
Source0: %name-%version.tar.bz2
Patch: mdds-1.5.0-python3.patch

# Automatically added by buildreq on Thu Jan 13 2022
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 libgpg-error libstdc++-devel perl python3 python3-base python3-module-Pygments python3-module-alabaster python3-module-babel python3-module-charset-normalizer python3-module-docutils python3-module-idna python3-module-imagesize python3-module-jinja2 python3-module-markupsafe python3-module-packaging python3-module-pkg_resources python3-module-pytz python3-module-requests python3-module-sphinx python3-module-urllib3 sh4 xz
BuildRequires: boost-devel-headers ctags doxygen gcc-c++ python3-module-breathe python3-module-sphinx_rtd_theme python3-module-sphinxcontrib-applehelp python3-module-sphinxcontrib-devhelp python3-module-sphinxcontrib-htmlhelp python3-module-sphinxcontrib-jsmath python3-module-sphinxcontrib-qthelp python3-module-sphinxcontrib-serializinghtml

BuildRequires: boost-devel
%description
A collection of multi-dimensional data structures and indexing algorithms.

It implements the following data structures:
* segment tree
* flat segment tree
* rectangle set
* point quad tree
* multi type matrix
* multi type vector

See README for a brief description of the structures.

%package devel
Group: Development/C++
Summary: Headers for %name
BuildArch: noarch
Requires: boost-devel
Provides: %name-static = %version-%release

%package doc
Group: Development/C++
Summary: Docs for %name
BuildArch: noarch
Provides: %name-static = %version-%release

%description devel
Headers for %name.

%description doc
Docs for %name.

%prep
%setup
%patch -p0
# this is only used in tests
%autoreconf
sed -i -e '/^CPPFLAGS_NODEBUG=/s/=.*/="%optflags"/' configure

%build
%configure --enable-docs CXXFLAGS="-fexcess-precision=fast"
%make_build all
%make_build doc-sphinx

%check
%make_build check

%install
%makeinstall

ln -sr %buildroot/%_includedir/%name-*/%name  %buildroot/%_includedir/%name

ln -sr %buildroot/%_datadir/pkgconfig/%name-*pc %buildroot/%_datadir/pkgconfig/%name.pc

install -dm 755 %buildroot/%_docdir/%name-%version

cp -a ./doc/_build %buildroot/%_docdir/%name-%version/html
cp -a ./example %buildroot/%_docdir/%name-%version/

%files doc
%_docdir/%name-%version/*
%exclude %_docdir/%name

%files devel
%doc *.md CHANGELOG AUTHORS
%_includedir/*
%_datadir/pkgconfig/*

%changelog
