%define defphp php%php_defver
%define webappdir %webserver_webappsdir/mediawiki
%define major 1.43

Name: mediawiki
Version: %major.0
Release: alt2

Summary: A wiki engine, typical installation (%defphp with Apache2 and MySQL support)

License: %gpl2plus
Group: Networking/WWW
Url: http://www.mediawiki.org/
Vcs: https://github.com/wikimedia/mediawiki

Packager: Vitaly Lipatov <lav@altlinux.ru>

BuildArch: noarch

Source0: http://releases.wikimedia.org/mediawiki/%major/%name-%version.tar
Source1: mediawiki-apache2-alt-configs.tar
Source2: README.ALT-ru_RU.UTF-8
Source3: install_php_config.sh
Source4: mediawiki.ini
Source5: README.UPGRADE.ALT-ru_RU.UTF-8
Source6: AdminSettings.sample
Source7: 99-read-user-configs.php

Patch: %name-1.31-alt.patch
Patch1: %name-1.40-config-path.patch

BuildRequires(pre): rpm-macros-apache2
BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-mediawiki >= 0.5
BuildRequires(pre): rpm-build-webserver-common
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-php

Requires: %name-common = %EVR
Requires: %name-apache2
Requires: %defphp-mysqlnd-mysqli

%description
MediaWiki is the software used for Wikipedia and the other Wikimedia
Foundation websites. Compared to other wikis, it has an excellent
range of features and support for high-traffic websites using multiple
servers

This package supports wiki farms. Configure it through the web
interface. Remember to secure the config dir after completing the
configuration.

This is a typical %name installation (with Apache2 and MySQL support).

Also you can install %name-%defphp
package to get all needed php requires.

If you wish %name without any php dependencies, install only %name-common package.


%package -n %name-%defphp
Summary: Mediawiki's requires for %defphp
Group: Networking/WWW
Requires: webserver-common
# https://www.mediawiki.org/wiki/Compatibility
Requires: %defphp-libs >= 8.0.0
# inside %defphp-libs
# Requires: %defphp-ctype %defphp-iconv %defphp-json %defphp-xml
Requires: %defphp-dom %defphp-fileinfo %defphp-intl %defphp-mbstring
Requires: %defphp-mcrypt %defphp-xmlreader %defphp-gd
Requires: %defphp-opcache %defphp-apcu
Requires: %defphp-openssl

Requires: %name-common = %EVR


%package -n %name-common
Summary: Common files for %name
Group: Networking/WWW
Requires: webserver-common

Requires: diffutils
Requires: pear-Mail >= 1.4.1

AutoProv:no
AutoReq:no

# since 1.20
Provides: mediawiki-extensions-ParserFunctions
Obsoletes: mediawiki-extensions-ParserFunctions

Provides: mediawiki-extensions-ConfirmEdit
Obsoletes: mediawiki-extensions-ConfirmEdit

Provides: mediawiki-extensions-SearchSuggest
Obsoletes: mediawiki-extensions-SearchSuggest

Provides: mediawiki-extensions-Nuke
Provides: mediawiki-extensions-Renameuser
Provides: mediawiki-extensions-WikiEditor

# since 1.21
Provides: mediawiki-extensions-Cite
Obsoletes: mediawiki-extensions-Cite

Provides: mediawiki-extensions-ImageMap
Obsoletes: mediawiki-extensions-ImageMap

Provides: mediawiki-extensions-Poem
Obsoletes: mediawiki-extensions-Poem

Conflicts: mediawiki-extensions-FCKEditor

Provides: mediawiki-extensions-TitleBlacklist
Provides: mediawiki-extensions-SpamBlacklist
Provides: mediawiki-extensions-InputBox
Provides: mediawiki-extensions-Interwiki
Provides: mediawiki-extensions-LocalisationUpdate
Provides: mediawiki-extensions-TitleBlacklist

# since 1.22
Provides: mediawiki-extensions-SimpleAntiSpam
Provides: mediawiki-extensions-PostEdit
Provides: mediawiki-extensions-Vector

# since 1.23
Provides: mediawiki-extensions-ExpandTemplates
Provides: mediawiki-extensions-AssertEdit

# since 1.27
Provides: mediawiki-extensions-CiteThisPage
Provides: mediawiki-extensions-Gadgets

# since 1.29?
# we pack separate subpackage since 1.35
#Provides: mediawiki-extensions-PdfHandler
#Conflicts: mediawiki-extensions-PdfHandler < 1.24

# since 1.31
Provides: mediawiki-extensions-CategoryTree
Obsoletes: mediawiki-extensions-CategoryTree
Provides: mediawiki-extensions-CodeEditor
Obsoletes: mediawiki-extensions-CodeEditor
Provides: mediawiki-extensions-MultimediaViewer
Obsoletes: mediawiki-extensions-MultimediaViewer
Provides: mediawiki-extensions-OATHAuth
Obsoletes: mediawiki-extensions-OATHAuth
Provides: mediawiki-extensions-ReplaceText
Obsoletes: mediawiki-extensions-ReplaceText

# since 1.33
Obsoletes: mediawiki-extensions-StubManager

# since 1.34
# we pack separate subpackage since 1.37.1
#Provides: mediawiki-extensions-Scribunto
#Obsoletes: mediawiki-extensions-Scribunto
Provides: mediawiki-extensions-PageImages
Obsoletes: mediawiki-extensions-PageImages
Provides: mediawiki-extensions-TextExtracts
Obsoletes: mediawiki-extensions-TextExtracts

# since 1.35
Provides: mediawiki-extensions-VisualEditor
Obsoletes: mediawiki-extensions-VisualEditor
Provides: mediawiki-extensions-Parsoid
Obsoletes: mediawiki-extensions-Parsoid
Provides: mediawiki-extensions-SecureLinkFixer
Obsoletes: mediawiki-extensions-SecureLinkFixer
Provides: mediawiki-extensions-TemplateData
Obsoletes: mediawiki-extensions-TemplateData

# since 1.39
# we pack separate subpackage since 1.39
#Provides: mediawiki-extensions-Math

Provides: mediawiki-extensions-AbuseFilter
Obsoletes: mediawiki-extensions-AbuseFilter

# since 1.40
Provides: mediawiki-extensions-DiscussionTools
Obsoletes: mediawiki-extensions-DiscussionTools
Provides: mediawiki-extensions-Echo
Obsoletes: mediawiki-extensions-Echo
Provides: mediawiki-extensions-Linter
Obsoletes: mediawiki-extensions-Linter
Provides: mediawiki-extensions-LoginNotify
Obsoletes: mediawiki-extensions-LoginNotify
Provides: mediawiki-extensions-Thanks
Obsoletes: mediawiki-extensions-Thanks


%description -n %name-common
MediaWiki is the software used for Wikipedia and the other Wikimedia
Foundation websites. Compared to other wikis, it has an excellent
range of features and support for high-traffic websites using multiple
servers.

%name-common have no php requires.

%description -n %name-%defphp
MediaWiki is the software used for Wikipedia and the other Wikimedia
Foundation websites. Compared to other wikis, it has an excellent
range of features and support for high-traffic websites using multiple
servers.

This package contains all needed %defphp requires.

%package -n %name-apache2
Summary: Apache2's requires and config files for %name
Group: Networking/WWW
Requires: %name-common = %EVR
Requires: %name-%defphp = %EVR
Requires: apache2-common >= 2.2.0
Requires: %_initdir/%apache2_dname
Requires: apache2-httpd-prefork
Requires: apache2-mod_%defphp

%description -n %name-apache2
Install this package, if you wish to run %name under apache2 webserver.


%package -n %name-mysql
Summary: Virtual package for mysql requires for %name
Group: Networking/WWW
Requires: %name-common = %version-%release
Requires: %defphp-mysqlnd-mysqli

%description -n %name-mysql
Install this package, if you wish to run %name with MySQL database.


%package -n %name-postgresql
Summary: Virtual package for postgresql requires for %name
Group: Networking/WWW
Requires: %name-common = %version-%release
Requires: %defphp-pgsql

%description -n %name-postgresql
Install this package, if you wish to run %name with PostgreSQL database.

%package -n %name-hiphop
Summary: Package with hihop support for %name
Group: Networking/WWW
Requires: %name-common = %version-%release

%description -n %name-hiphop
%summary

%package extensions-SyntaxHighlight_GeSHi
Epoch: 1
Summary: Extension for mediawiki to highlight source code with GeSHi
Summary(ru_RU.UTF-8): Расширение mediawiki для раскраски синтаксиса исходников с помощью GeSHi
Group: Networking/WWW
Requires: %name-common = %version-%release
Requires: python3-module-Pygments >= 2.2.0

%description extensions-SyntaxHighlight_GeSHi
The <syntaxhighlight> tags allow the display of preformatted code modules but in addition
they add coloring according to the code language settings. Like the <pre> tags
and the <poem> tags, they preserve white space, that is, they depict the code
module exactly as it was typed.

%package extensions-PdfHandler
Summary: PdfHandler extension shows uploaded pdf files in a multipage preview layout
Group: Networking/WWW
Requires: %name-common = %version-%release
Conflicts: %name-common < 1.35.0-alt4
# There are commands used. See https://www.mediawiki.org/wiki/Extension:PdfHandler
Requires: /usr/bin/gs
# poppler (needed for retrieving metainfo)
# Requires: /usr/bin/pdfinfo /usr/bin/pdftotext
# use convert wrapper from ImageMagick-tools or GraphicsMagick-ImageMagick-compat
Requires: /usr/bin/convert

%description extensions-PdfHandler
The extension shows uploaded pdf files in a multipage preview layout. With
enabled WebStore the extension generates automatically Images from the
specified page.

Recommended: poppler (for PDF metainfo retrieving)

%package extensions-Scribunto
Summary: The extension allows for embedding scripting languages in MediaWiki
Group: Networking/WWW
Requires: %name-common = %version-%release
Conflicts: %name-common < 1.37.1-alt1

# TODO: also can use php module luasandbox
Requires: /usr/bin/lua5.1
# we miss module versions
#Requires: php7-pcre >= 8.33
#Requires: php7-mbstring

%description extensions-Scribunto
The Scribunto (Latin: "they shall write") extension allows for embedding scripting languages in MediaWiki.
Currently the only supported scripting language is Lua.

%prep
%setup
%patch -p2
%patch1 -p2

%__subst "s|/usr/bin/python|/usr/bin/python3|" extensions/ConfirmEdit/*.py

%install
mkdir -p %buildroot%_mediawikidir/

# Copying to buildroot all files and directories and remove unneeded
cp -r * %buildroot%_mediawikidir/

# Not needed in the package (generate extra dependencies)
rm -rf %buildroot%_mediawikidir/maintenance/dev/
rm -rf %buildroot%_mediawikidir/maintenance/cssjanus/
rm -rf %buildroot%_mediawikidir/maintenance/hhvm/
rm -rf %buildroot%_mediawikidir/maintenance/resources/
rm -rf %buildroot%_mediawikidir/maintenance/{Makefile,mwjsduck-gen,jsduck/,resources/update-oojs.sh}
rm -rf %buildroot%_mediawikidir/tests/
rm -rf %buildroot%_mediawikidir/{*.php5,*.phtml}
rm -rf %buildroot%_mediawikidir/{COPYING,CREDITS,FAQ,HISTORY,README*,RELEASE-NOTES-*,UPGRADE}
rm -rf %buildroot%_mediawikidir/resources/lib/oojs-ui/update-oojs-ui.sh

rm -fr %buildroot%_mediawikidir/includes/zhtable
rm -rf %buildroot%_mediawikidir/maintenance/language/zhtable

rm -rf %buildroot%_mediawikidir/vendor/zordius/lightncandy/build/

# remove embedded lua binaries
rm -rv %buildroot%_mediawikidir/extensions/Scribunto/includes/Engines/LuaStandalone/binaries

# devel tools, reqs node
rm -rfv %buildroot%_mediawikidir/vendor/wikimedia/parsoid/tools/test.selser.sh
rm -rfv %buildroot%_mediawikidir/vendor/wikimedia/parsoid/bin/
rm -rv %buildroot%_mediawikidir/extensions/VisualEditor/lib/ve/bin/
rm -rv %buildroot%_mediawikidir/extensions/VisualEditor/bin/
rm -rv %buildroot%_mediawikidir/vendor/wikimedia/wikipeg/tools/impact
rm -rfv  %buildroot%_mediawikidir/skins/MinervaNeue/dev-scripts


# https://www.mediawiki.org/wiki/Manual:Security#Upload_security
#find %buildroot%_mediawikidir/ \
#  \( -name .htaccess -or -name \*.cmi \) \
#  -print0 \
#  | xargs -r0 rm -v

# packed as docs
rm -rf %buildroot%_mediawikidir/docs/


mkdir -p %buildroot%_mediawikidir/config/

sed -i -e "s/__VERSION__/%version/g" %SOURCE2
sed -i -e "s/__VERSION__/%version/g" %SOURCE5
install -m 644 %SOURCE2 ./
install -m 755 %SOURCE3 ./
install -m 644 %SOURCE4 ./
install -m 644 %SOURCE5 ./


# fix permissions
#chmod +x %buildroot%_mediawikidir/bin/*
find %buildroot%_mediawikidir -name \*.pl -print0 | xargs -r0 chmod +x


mkdir -p %buildroot%webappdir/
cd %buildroot%_mediawikidir/
mv cache images %buildroot%webappdir/
ln -sf %webappdir/{cache,images} .

mkdir config/LocalSettings.d/
install -m 644 %SOURCE7 config/LocalSettings.d/
ln -sf %webappdir/config/LocalSettings.php config/

cd %buildroot%webappdir/
mkdir -p config/LocalSettings.d
install -m 600 %SOURCE6 config/
ln -s %_mediawikidir wiki

# Configs for apache2
mkdir -p %buildroot%apache2_confdir
pushd %buildroot%apache2_confdir
tar xvSf %SOURCE1
find -name \*.conf |xargs sed -i "s|WEBAPPDIR|%webappdir|"
popd

# TODO: use macro
# config for enable bundled ParserFunctions
cat > %buildroot%_mediawiki_settings_dir/50-ParserFunctions.php << EOF
<?php
wfLoadExtension('ParserFunctions');

# enable StringFunctions (like {{#pos, {{#len) by default
\$wgPFEnableStringFunctions = true;
EOF

cat > %buildroot%_mediawiki_settings_dir/50-PdfHandler.php << EOF
<?php
wfLoadExtension('PdfHandler');

\$wgFileExtensions[] = 'pdf';
EOF

cat > %buildroot%_mediawiki_settings_dir/50-Scribunto.php << EOF
<?php
wfLoadExtension('Scribunto');
\$wgScribuntoDefaultEngine = 'luastandalone';
\$wgScribuntoEngineConf['luastandalone']['luaPath'] = '/usr/bin/lua5.1';
EOF

# remove embedded python module
rm -rv %buildroot%_mediawikidir/extensions/SyntaxHighlight_GeSHi/pygments/*
# instead of set wgPygmentizePath
ln -s %_bindir/pygmentize3 %buildroot%_mediawikidir/extensions/SyntaxHighlight_GeSHi/pygments/pygmentize

# TODO: use macro
# config for enable bundled SyntaxHighlight_GeSHi
cat > %buildroot%_mediawiki_settings_dir/50-SyntaxHighlight_GeSHi.php << EOF
<?php
wfLoadExtension('SyntaxHighlight_GeSHi');
EOF

# pack separately
rm -rv %buildroot%_mediawikidir/extensions/Math/

%pre -n %name-common
if [ -L %_mediawikidir/config ]; then
	rm -f %_mediawikidir/config
fi
if [ -d %_datadir/%name/images -a ! -L %_datadir/%name/images ]; then
	rmdir %_datadir/%name/images 2>/dev/null || {
		mv %_datadir/%name/images %_datadir/%name/images.rpmsave
		echo "%_datadir/%name/images saved as %_datadir/%name/images.rpmsave"
	}
fi

%post -n %name-common
if [ $1 -eq 2 ] ; then
	cat <<EOF
Running MediaWiki update:
 # php %webappdir/wiki/maintenance/update.php
Check full upgrading manual on https://www.mediawiki.org/wiki/Manual:Upgrading
EOF
php %webappdir/wiki/maintenance/update.php || :
fi

%post -n %name-apache2
if [ "$CONF_OK" = "1" ]; then
    service %apache2_dname condrestart ||:
fi

%postun -n %name-apache2
if [ "$1" = "0" ] ; then # last uninstall
    service %apache2_dname condrestart ||:
fi

%files

%files -n %name-%defphp

%files -n %name-common
%add_findreq_skiplist %_datadir/%name/config/LocalSettings.php
%_mediawikidir/
%exclude %_mediawikidir/extensions/SyntaxHighlight_GeSHi/
%exclude %_mediawiki_settings_dir/50-SyntaxHighlight_GeSHi.php
%exclude %_mediawikidir/extensions/PdfHandler/
%exclude %_mediawikidir/extensions/Scribunto/
%exclude %_mediawiki_settings_dir/50-PdfHandler.php
%exclude %_mediawiki_settings_dir/50-Scribunto.php
#exclude %_datadir/%name/maintenance/hiphop/
%attr(2750,root,%webserver_group) %dir %webappdir/
%attr(2770,root,%webserver_group) %dir %webappdir/config/
%attr(2770,root,%webserver_group) %dir %webappdir/config/LocalSettings.d/
%attr(2775,root,%webserver_group) %dir %webappdir/images/
%attr(2770,root,%webserver_group) %dir %webappdir/cache/
%webappdir/wiki/
%webappdir/cache/.htaccess
%webappdir/images/*
%webappdir/images/.htaccess
%webappdir/config/AdminSettings.sample

%doc COPYING CREDITS FAQ HISTORY README.md RELEASE-NOTES-%major UPGRADE
%doc README.ALT-ru_RU.UTF-8 README.UPGRADE.ALT-ru_RU.UTF-8 install_php_config.sh mediawiki.ini
%doc docs

%files -n %name-apache2
%config %apache2_mods_start/*.conf
%config %apache2_extra_available/*.conf
%config %apache2_extra_start/*.conf
%config(noreplace) %apache2_sites_available/*.conf

# deprecated
%files -n %name-mysql

# deprecated
%files -n %name-postgresql

#%files -n %name-hiphop
#%_datadir/%name/maintenance/hiphop/

%files extensions-SyntaxHighlight_GeSHi
%_mediawikidir/extensions/SyntaxHighlight_GeSHi/
%_mediawiki_settings_dir/50-SyntaxHighlight_GeSHi.php
%doc extensions/SyntaxHighlight_GeSHi/README

%files extensions-PdfHandler
%_mediawikidir/extensions/PdfHandler/
%_mediawiki_settings_dir/50-PdfHandler.php

%files extensions-Scribunto
%_mediawikidir/extensions/Scribunto/
%_mediawiki_settings_dir/50-Scribunto.php

%changelog
