%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%ifarch %qt5_qtwebengine_arches
%def_enable qtwebengine
%else
%def_disable qtwebengine
%endif

Name: merkaartor
Version: 0.19.0
Release: alt2.1

Summary: an OpenStreetMap editor
License: GPLv2
Group: Sciences/Geosciences
Url: https://github.com/openstreetmap/merkaartor

# https://github.com/openstreetmap/merkaartor.git
Source: %name-%version.tar
Patch1: %name-0.18.3-fedora-no-git-version.patch

BuildRequires(pre): rpm-macros-qt5-webengine
BuildRequires: boost-devel gcc-c++ glibc-devel-static
BuildRequires: libgdal-devel libproj-devel libexiv2-devel zlib-devel libsqlite3-devel
BuildRequires: qt5-base-devel qt5-svg-devel qt5-tools-devel
%if_enabled qtwebengine
BuildRequires: qt5-webengine-devel
%endif
BuildRequires: libqtsingleapplication-qt5-devel

%description
Merkaartor is an openstreetmap mapping program.
Merkaartor focuses on providing a visually pleasing but performant
editing environment for free geographical data.

%prep
%setup
%patch1 -p1

# remove bundled libraries
rm -rf 3rdparty

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%add_optflags -I%_includedir/qt5/QtSolutions

lrelease-qt5 Merkaartor.pro
%qmake_qt5 \
	CONFIG+=release CONFIG+=force_debug_info \
	PREFIX=%_prefix \
%if_enabled qtwebengine
	USEWEBENGINE=1 \
%endif
	SYSTEM_QTSA=1 \
	TRANSDIR_MERKAARTOR=%_datadir/%name/translations/ \
	-after QMAKE_CFLAGS+='%optflags' \
	-after QMAKE_CXXFLAGS+='%optflags' \
	Merkaartor.pro

%make_build

%install
%make_install INSTALL_ROOT=%buildroot LIB_SUFFIX=%_libsuff install

%files
%_bindir/merkaartor
%_datadir/%name/
%_datadir/metainfo/*.xml
%_libdir/%name/
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.png

%changelog
