%define _unpackaged_files_terminate_build 1

Name: minify-html
Version: 0.15.0
Release: alt1

Summary: A Rust HTML minifier
License: MIT
Group: Text tools
Url: https://github.com/wilsonzlin/minify-html

# x32 systems not supported
ExcludeArch: i586 armh

Source0: %name-%version.tar
Source1: crates.tar

BuildRequires: rust-cargo /proc
BuildRequires: rpm-build-python3 python3-module-setuptools
BuildRequires: golang
BuildRequires: cargo-vendor-checksum diffstat

%package -n python3-module-minify-html
Summary: A Rust HTML minifier
Group: Development/Python

%description
Rust HTML minifier meticulously optimised for speed and effectiveness,
with bindings for other languages.

%description -n python3-module-minify-html
Rust HTML minifier meticulously optimised for speed and effectiveness,
with bindings for other languages.
This package contains Python bindings.

%prep
%setup -a1
%ifdef bootstrap
# collect dependencies for the project
cargo vendor alt/crates --manifest-path minhtml/Cargo.toml --sync minify-html-python/Cargo.toml
tar cf %SOURCE1 alt/crates
%else
tar xf %SOURCE1
%endif

cat > minify-html-python/__init__.py << 'E_O_F'
from .minify_html import *

__doc__ = minify_html.__doc__
E_O_F

%build
export CARGO_HOME=${PWD}/cargo
cargo build --manifest-path minhtml/Cargo.toml --release
cargo build --manifest-path minify-html-python/Cargo.toml --release
cp target/release/libminify_html_python.so minify-html-python/minify_html.so
pushd minify-html-python
%python3_build
popd

%install
install -pm0755 -D target/release/minhtml %buildroot%_bindir/minhtml
mkdir -p %buildroot%python3_sitelibdir/minify_html
pushd minify-html-python
install -pm0644 __init__.py %buildroot%python3_sitelibdir/minify_html
install -pm0644 minify_html.so %buildroot%python3_sitelibdir/minify_html
%python3_install --install-lib=%python3_sitelibdir --single-version-externally-managed
popd

%files
%doc README.md
%_bindir/minhtml

%files -n python3-module-minify-html
%python3_sitelibdir/*

%changelog
