Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Enable oldstyle to have a nearly nothing requiring package after rebuilding
%global oldstyle 0

Summary:         Drive and jump with some kind of car across the moon
Name:            moon-buggy
Version:         1.0.51
Release:         alt2_24
License:         GPL+
URL:             http://seehuhn.de/pages/%{name}
Source0:         http://seehuhn.de/media/programs/%{name}-%{version}.tar.gz
Source1:         http://seehuhn.de/media/programs/%{name}-sound-%{version}.tar.gz
Source2:         %{name}.desktop
Source3:         %{name}-sound.desktop
Patch0:          moon-buggy-1.0.51-pause.patch
Patch1:          moon-buggy-1.0.51-sound.patch
%if 0%{?rhel} && 0%{?rhel} <= 7
%endif
BuildRequires:   gcc libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel, makeinfo
%if !%{oldstyle}
BuildRequires:   libesd-devel, desktop-file-utils, autoconf, automake
%endif
Source44: import.info

%description
Moon-buggy is a simple character graphics game where you drive some kind
of car across the moon's surface. Unfortunately there are dangerous craters
there. Fortunately your car can jump over them! 

The game has some resemblance of the classic arcade game moon-patrol which
was released in 1982. A clone of this game was relased for the Commodore
C64 in 1983. The present, ASCII art version of moon-buggy was written many
years later by Jochen Voss.

%prep
%setup -q -a 1
%patch0 -p1 -b .pause
%if !%{oldstyle}
%patch1 -p1 -b .sound
mv -f %{name}-%{version}/* .
autoreconf -f -i
%endif

%build
%configure --sharedstatedir=%{_localstatedir}/games
%make_build

%install
make DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p" install

# Create zero-sized highscore file
touch $RPM_BUILD_ROOT%{_localstatedir}/games/%{name}/mbscore

# Install working *.desktop files and an icon
%if !%{oldstyle}
desktop-file-install --vendor "" --dir=$RPM_BUILD_ROOT%{_datadir}/applications %{SOURCE2}
desktop-file-install --vendor "" --dir=$RPM_BUILD_ROOT%{_datadir}/applications %{SOURCE3}

install -D -p -m 644 %{name}.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}.png
%endif

# Some file cleanups
rm -f $RPM_BUILD_ROOT%{_infodir}/dir

# Convert everything to UTF-8
iconv -f iso-8859-1 -t utf-8 -o ChangeLog.utf8 ChangeLog
sed -i 's|\r$||g' ChangeLog.utf8
touch -c -r ChangeLog ChangeLog.utf8
mv -f ChangeLog.utf8 ChangeLog

iconv -f iso-8859-1 -t utf-8 -o TODO.utf8 TODO
sed -i 's|\r$||g' TODO.utf8
touch -c -r TODO TODO.utf8
mv -f TODO.utf8 TODO

%files 
%doc --no-dereference COPYING
%doc ANNOUNCE AUTHORS ChangeLog README THANKS
%if !%{oldstyle}
%doc README.sound
%{_datadir}/%{name}/
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/applications/%{name}.desktop
%{_datadir}/applications/%{name}-sound.desktop
%endif
%attr(2711,root,games) %{_bindir}/%{name}
%{_mandir}/man6/%{name}.6*
%{_infodir}/%{name}.info.*
%attr(0775,root,games) %{_localstatedir}/games/%{name}
%verify(not md5 size mtime) %config(noreplace) %attr(664,root,games) %{_localstatedir}/games/%{name}/mbscore

%changelog
