Name: motion
Version: 4.5.1
Release: alt1

Summary: %name - Detect motion using a video4linux device
License: GPLv2
Group: Video

Url: https://motion-project.github.io
# Source0-url: https://github.com/Motion-Project/motion/archive/refs/tags/release-%version.tar.gz
Source0: %name-%version.tar
Patch3: motion-4.1.1-alt-mysql8-transition.patch

BuildRequires: libavformat-devel libjpeg-devel postgresql-devel zlib-devel
BuildRequires: libmjpegtools-devel libsqlite3-devel
BuildRequires: libpostproc-devel libswscale-devel libavdevice-devel
BuildRequires: libavfilter-devel libv4l-devel
BuildRequires: libavformat-devel libjpeg-devel libmysqlclient-devel postgresql-devel zlib-devel libwebp-devel
BuildRequires: libmicrohttpd-devel

%description
With motion you can use a video4linux device as a motion detector.
It will make snapshots if motion is detected.

%prep
%setup
#patch3 -p0

sed -i 's|<postgresql[/]libpq-fe.h>|<pgsql/libpq-fe.h>|' src/%name.h
sed -i 's|\(if [\\(]cnt->conf\.mysql_db && sqltype[\)]\)|//\1|' src/event.c
sed -i 's|\(put_mysql[\(]&cnt->conf, cnt->database, filename, tm, sqltype[\)]\)|//\1|' src/event.c
sed -i 's|\(^.*c->quality\).*|//\1|' src/ffmpeg.c
# libwebpmux.so: undefined reference to symbol 'WebPMemoryWriterInit'
sed -i 's|libwebpmux|libwebpmux libwebp|' configure.ac

%build
%ifarch %e2k
# asm under that ifdef
%add_optflags -U__MMX__
%endif
%autoreconf
%configure \
	--with-webp \
	--without-optimizecpu

%make_build

%install
%makeinstall_std

mv %buildroot%_defaultdocdir/%name %buildroot%_defaultdocdir/%name-%version
rename -- -dist.conf .conf %buildroot%_sysconfdir/%name/*.conf
install -pDm0644 data/%name.service %buildroot/%_unitdir/%name.service

%find_lang %name

%files -f %name.lang
%doc README.md
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%config(noreplace) %_sysconfdir/%name/camera?.conf
%_unitdir/*.service
%_bindir/%name
%_man1dir/*

%changelog
