Name: mrtg
Version: 2.17.10
Release: alt1

Summary: Multi Router Traffic Grapher
Group: Monitoring
License: GPL-2.0+
Url: http://oss.oetiker.ch/mrtg/

Packager: Ilya Mashkin <oddity@altlinux.ru>

Source0: http://oss.oetiker.ch/mrtg/pub/%name-%version.tar.gz
Source1: mrtg.cfg
Source4: mrtg.cron.d
Source5: mrtg.iptables
Source6: mrtg-lo0.cfg
Source7: mrtg.cpuinfo
Source8: README.ALT-ru_RU.KOI8-R

Requires(pre,postun): sysstat

BuildRequires: fontconfig freetype2-devel groff-base libgd2-devel libjpeg-devel libpng-devel perl-Math-BigInt perl-Net-SNMP zlib-devel
BuildRequires: perl-Pod-Parser

%description
The Multi Router Traffic Grapher (MRTG) is a tool to monitor the traffic
load on network-links. MRTG generates HTML pages containing GIF or PNG
images which provide a LIVE visual representation of this traffic.

%package contrib
Summary: Multi Router Traffic Grapher - contribs
Group: Monitoring
AutoReq: no
Requires: %name = %version-%release

%description contrib
Scripts in contrib/ directory of MRTG source distribution

%define _contentdir /var/www/html/%name
%define _libmrtg /usr/lib/%{name}2

%define _perl_lib_path %perl_vendor_privlib:%_libmrtg
%filter_from_provides /^perl(/d
%filter_from_requires /^perl(\(BER\|MRTG_lib\|Net_SNMP_util\|SNMP_Session\|SNMP_util\|locales_mrtg\)\.pm)/d
%add_findprov_skiplist */contrib/*
%add_findprov_skiplist */helpers/*

%prep
%setup -q
echo "Removing .orig's..."
find . -name "*.orig" -print0 -exec rm -f \{\} \; \
 > /dev/null

cp -p %SOURCE8 .

mv -f COPYING COPYING.orig
ln -s $(relative %_licensedir/GPL-2 %_docdir/%name/COPYING) COPYING

%build
%configure
%make_build

find contrib -type f -print0 -exec perl -pi \
 -e 's;^#!/.*/perl.*;#!/usr/bin/perl;gi' \{\} \; \
 > /dev/null

find contrib -type f -print0 -exec perl -pi \
 -e 's;/usr/local/bin/;/usr/bin/;gi' \{\} \; \
 > /dev/null

find contrib -type f -print0 -exec perl -pi \
 -e 's;/usr/local/mrtg/(bin/)?mrtg;/usr/bin/mrtg;gi' \{\} \; \
 > /dev/null

find . -name "*.pl" -print0 -exec perl -pi -e 's;\015;;gi' \{\} \; \
 > /dev/null

#tar -cf - contrib | gzip -9nf > contrib.tar.gz

%install
%make_install DESTDIR=%buildroot install
rm -rf %buildroot{%_docdir,%_datadir}/mrtg2

# another try to work around x86_64
if [ "%_libdir" == "/usr/lib64" ]; then
	mkdir -p %buildroot/usr/lib
	mv %buildroot%_libdir/mrtg2 %buildroot/usr/lib
	rm -rf %buildroot%_libdir
fi

# get rid of a copy of standard Pod perl modules
rm -rf %buildroot%_libmrtg/Pod

mkdir -p %buildroot{%_sysconfdir/%name,%_sysconfdir/cron.d,%_contentdir/images,%_libmrtg/helpers,%_localstatedir/%name}

install -m 644 images/* %buildroot%_contentdir/images
install -m 644 %SOURCE1 %buildroot%_sysconfdir/%name
install -m 640 %SOURCE4 %buildroot%_sysconfdir/cron.d/%name

install -m 755 %SOURCE5 %buildroot/%_libmrtg/helpers/iptables-accounting.pl
install -m 644 %SOURCE6 %buildroot%_sysconfdir/%name
install -m 755 %SOURCE7 %buildroot/%_libmrtg/helpers/cpuinfo.pl

cp -r contrib %buildroot%_libmrtg/

%pre
/usr/sbin/groupadd -r -f %name &> /dev/null ||:
/usr/sbin/useradd -r -g %name -d /dev/null -s /dev/null -N %name &> /dev/null ||:

%files
%doc CHANGES COPYRIGHT MANIFEST README README.ALT-ru_RU.KOI8-R THANKS
%doc --no-dereference COPYING

%config(noreplace) %_sysconfdir/%name/mrtg*.cfg
%config(noreplace) %attr(640,root,root) %_sysconfdir/cron.d/%name
%dir %attr(3770,root,mrtg) %_sysconfdir/%name
%dir %attr(3775,root,mrtg) %_contentdir
%dir %attr(3775,root,mrtg) %_localstatedir/%name
%dir %_libmrtg
%dir %_libmrtg/helpers

%dir %_contentdir/images
%_contentdir/images/*
%_man1dir/indexmaker*.1*
%_man1dir/cfgmaker*.1*
%_man1dir/mrtg*.1*
%_man1dir/rateup.1*
%_man3dir/mrtg*
%_bindir/*
%_libmrtg/*.pm
%_libmrtg/helpers/*

%files contrib
%dir %_libmrtg/contrib
%_libmrtg/contrib/*

%changelog
