%define ver_major 0.103
%define libname libmsi
%define api_ver 1.0

%def_enable check

Name: msitools
Version: %ver_major
Release: alt1

Summary: Windows Installer tools
Group: File tools
License: GPLv2+
Url: https://ftp.gnome.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define gcab_ver 0.2
%define vala_ver 0.16

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: libgcab-devel >= %gcab_ver
BuildRequires: libgio-devel libgsf-devel
BuildRequires: gobject-introspection-devel
BuildRequires: vala-tools >= %vala_ver

%description
msitools is a set of programs to inspect and build Windows Installer
(.MSI) files. It is based on libmsi, a portable library to read and
write .MSI files. libmsi in turn is a port of (and a subset of) Wine's
implementation of the Windows Installer.

%package -n %libname
Summary: A library to manipulate Windows .MSI files
Group: System/Libraries
License: LGPLv2+

%description -n %libname
%libname is a GObject library to manipulate with Windows Installer files.
It is a port from the MSI library of the Wine project.

%package -n %libname-devel
Summary: A library to manipulate Windows .MSI files (development package)
Group: Development/C
License: LGPLv2+
Requires: %libname = %version-%release

%description -n %libname-devel
This package provides the headers and library to develop applications
using %libname.

%package -n %libname-gir
Summary: GObject introspection data for the %libname
Group: System/Libraries
License: LGPLv2+
Requires: %libname = %version-%release

%description -n %libname-gir
%libname is a GObject library to manipulate with Windows Installer files.
This package provides GObject introspection data for the %libname.

%package -n %libname-gir-devel
Summary: GObject introspection devel data for the %name
Group: Development/Other
License: LGPLv2+
BuildArch: noarch
Requires: %libname-devel = %version-%release
Requires: %libname-gir = %version-%release

%description -n %libname-gir-devel
%libname is a GObject library to manipulate with Windows Installer files.
This package provides GObject introspection devel data for the %libname.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/msibuild
%_bindir/msidiff
%_bindir/msidump
%_bindir/msiextract
%_bindir/msiinfo
%_bindir/wixl
%_bindir/wixl-heat
%_datadir/bash-completion/completions/msitools
%_datadir/wixl-%version/
%doc NEWS README* TODO

%files -n %libname
%_libdir/%libname-%api_ver.so.*

%files -n %libname-devel
%_includedir/%libname-%api_ver/
%_libdir/%libname-%api_ver.so
%_pkgconfigdir/%libname-%api_ver.pc
%_vapidir/%libname-%api_ver.vapi
%_vapidir/%libname-%api_ver.deps

%files -n %libname-gir
%_typelibdir/Libmsi-%api_ver.typelib

%files -n %libname-gir-devel
%_girdir/Libmsi-%api_ver.gir

%changelog
