%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%def_enable dc
%def_disable fw_mgr
%def_enable xml2
%def_enable cs
%def_enable inband
%def_enable openssl

Name: mstflint
Version: 4.26.0
Release: alt1

Summary: Mellanox firmware burning application
License: GPLv2 or BSD
Group: System/Base

Url: http://openib.org/
# VCS-git: https://github.com/Mellanox/mstflint.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: autoconf-archive
BuildRequires: gcc-c++
%{?_enable_dc:BuildRequires: zlib-devel}
%{?_enable_fw_mgr:BuildRequires: libcurl-devel liblzma-devel zlib-devel boost-devel}
%{?_enable_xml2:BuildRequires: libxml2-devel}
%{?_enable_inband:BuildRequires: rdma-core-devel}
%{?_enable_cs:BuildRequires: libssl-devel}
%{?_enable_openssl:BuildRequires: libssl-devel openssl}
BuildRequires: libiniparser-devel jsoncpp-devel libmuparser-devel libsqlite3-devel
AutoReq: yes, nopython

%add_python_compile_exclude %_libdir/%name/python_tools
%add_python3_compile_exclude %_libdir/%name/python_tools
%add_python3_path %_libdir/%name/python_tools


%description
This package contains a tool for burning updated firmware on to
Mellanox manufactured InfiniBand adapters.

%prep
%setup

%ifarch %e2k
sed -i "s/__x86_64__/__e2k__/" common/compatibility.h \
	mtcr_ul/packets_common.h tools_layouts/adb_to_c_utils.h
%endif

%build
mkdir config
echo "#define TOOLS_GIT_SHA \"%release\"" > common/gitversion.h

%autoreconf
%configure \
    %{subst_enable dc} \
    %{?_enable_fw_mgr:--enable-fw-mgr} \
    %{subst_enable xml2} \
    %{subst_enable inband} \
    %{subst_enable cs} \
    %{subst_enable openssl} \
    MSTFLINT_VERSION_STR="%name %version-%release"

%make_build
sed -i "s|^#!/usr/bin/env python.*|#!/usr/bin/python3|" tracers/fwtrace/mstfwtrace.py
sed -i "s|^#!/usr/bin/python$|#!/usr/bin/python3|" common/autocomplete/mft_help_to_completion.py

%install
%makeinstall_std
rm -rf %buildroot%_includedir
rm -f  %buildroot%_libdir/*.a

%files
%_bindir/*
%_datadir/%name
%dir %_libdir/%name
%_libdir/%name/python_tools
%_man1dir/*

%changelog
