%define _unpackaged_files_terminate_build 1
%def_enable libdmmp

%define syslibdir %_libdir
%define libmpathdir %syslibdir/multipath
%define bindir %_sbindir

# filter runtime dependency on systemctl (ALT bug 54047)
%filter_from_requires /systemctl/d

Name: multipath-tools
Version: 0.11.1
Release: alt3

Summary: Tools to manage multipath devices with device-mapper
License: GPL-2.0-only
Group: System/Configuration/Hardware

Url: https://github.com/opensvc/multipath-tools
Vcs: https://github.com/opensvc/multipath-tools.git
Source: %name-%version.tar
Source3: multipathd.init
Source4: multipath.modules
Source5: multipath.conf
Patch1: %name-%version.patch

Provides: device-mapper-multipath = %EVR
Provides: /sbin/multipath /sbin/multipathd /sbin/mpathpersist /sbin/multipathc /sbin/mpathconf
Conflicts: filesystem < 3

Requires: libmultipath = %EVR
Requires: kpartx = %EVR
Requires: dmsetup
Requires: udev-rules-sgutils sg3_utils

BuildRequires: libaio-devel libdevmapper-devel libreadline-devel libudev-devel libsystemd-devel libmount-devel
BuildRequires: libuserspace-rcu-devel
%{?_enable_libdmmp:BuildRequires: libjson-c-devel}

%description
This package provides the tools to manage multipath devices by
instructing the device-mapper multipath module what to do.
The tools are:
- multipath: lists and configures multipath devices.
- multipathd: monitors paths; as paths fail and come back, it may
  initiate path group switches.

%package -n libmultipath
Summary: The %name modules and shared library
License: GPL-2.0-only AND LGPL-2.1-only AND LGPL-2.0-or-later
Group: System/Libraries
Conflicts: multipath-tools <= 0.4.9-alt3

%description -n libmultipath
The libmultipath provides the path checker
and prioritizer modules. It also contains the multipath shared library,
libmultipath.

%package -n libmultipath-devel
Summary: Development libraries and headers for %name
Group: Development/C
License: GPL-2.0-only AND LGPL-2.0-or-later
Requires: libmultipath = %EVR

%description -n libmultipath-devel
This package contains the files need to develop applications that use
multipath-tools's libmpathpersist and libmpathcmd libraries.

%package -n kpartx
Summary: Partition device manager for device-mapper devices
Group: System/Configuration/Hardware
License: GPL-2.0-only
Conflicts: multipath-tools <= 0.4.9-alt3
Provides: /sbin/kpartx

%description -n kpartx
kpartx manages partition creation and removal for device-mapper devices.

%package -n libdmmp
Summary: multipath-tools C API library
Group: System/Libraries
License: GPL-3.0-or-later

%description -n libdmmp
This package contains the shared library for the multipath-tools
C API library.

%package -n libdmmp-devel
Summary: device-mapper-multipath C API library headers
Group: Development/C
License: GPL-3.0-or-later
Requires: libdmmp = %EVR

%description -n libdmmp-devel
This package contains the files needed to develop applications that use
device-mapper-multipath's libdmmp C API library

%prep
%setup -q
%patch1 -p1

%build
unset RPM_OPT_FLAGS
%make_build \
%ifarch %e2k
    WARN_ONLY=1 \
%endif
    prefix=%_prefix \
    systemd_prefix=/usr \
    sys_execprefix=/usr \
    etc_prefix="" \
    bindir=%bindir \
    libudevdir=%_udevdir \
    syslibdir=%syslibdir \
    libdir=%libmpathdir \
    plugindir=%libmpathdir \
    usr_prefix=%_prefix \
    configdir=%_sysconfdir/multipath/conf.d \
    configfile=%_sysconfdir/multipath.conf \
    statedir=%_sysconfdir/multipath \
    runtimedir=/run \
    LIB=%_lib \
    %{?_disable_libdmmp: ENABLE_LIBDMMP=0} \
    EXTRAVERSION=%release

%install
mkdir -p %buildroot{%bindir,%_libdir,%_man8dir,%_initdir,%_unitdir,%_udevrulesdir,%_modulesloaddir,%_sysconfdir/multipath}
%makeinstall_std \
    prefix=%_prefix \
    systemd_prefix=/usr \
    sys_execprefix=/usr \
    DESTDIR=%buildroot \
    %{?_disable_libdmmp: ENABLE_LIBDMMP=0} \
    LIB=%_lib \
    bindir=%bindir \
    syslibdir=%syslibdir \
    libdir=%libmpathdir \
    plugindir=%libmpathdir \
    usr_prefix=%_prefix \
    configdir=%_sysconfdir/multipath/conf.d \
    rcdir=%_initrddir \
    udevrulesdir=%_udevrulesdir \
    unitdir=%_unitdir \
    libudevdir=%_udevdir \
    tmpfilesdir=%_tmpfilesdir \
    modulesloaddir=%_modulesloaddir \
    runtimedir=/run \
    EXTRAVERSION=%release

install -pm755 %SOURCE3 %buildroot%_initdir/multipathd
install -pm644 %SOURCE5 %buildroot%_sysconfdir/multipath.conf

%post
%post_service multipathd

%preun
%preun_service multipathd

%files
%doc README.md
%bindir/multipath
%bindir/multipathd
%bindir/mpathconf
%bindir/mpathpersist
%bindir/multipathc
%_udevrulesdir/*
%exclude %_udevrulesdir/*kpartx.rules
%_modulesloaddir/*
%dir %_sysconfdir/multipath
%config(noreplace) %attr(644,root,root) %_sysconfdir/multipath.conf
%_initdir/*
%_unitdir/*
%_tmpfilesdir/*
%_man5dir/*
%_man8dir/*
%exclude %_man8dir/kpartx.8.*

%files -n libmultipath
%syslibdir/libmultipath.so.*
%syslibdir/libmpathcmd.so.*
%syslibdir/libmpathpersist.so.*
%syslibdir/libmpathvalid.so.*
%syslibdir/libmpathutil.so.*
%dir %libmpathdir
%libmpathdir/*

%files -n libmultipath-devel
%syslibdir/libmultipath.so
%syslibdir/libmpathpersist.so
%syslibdir/libmpathcmd.so
%syslibdir/libmpathvalid.so
%syslibdir/libmpathutil.so
%_includedir/mpath_cmd.h
%_includedir/mpath_persist.h
%_includedir/mpath_valid.h
%_man3dir/mpath_*

%files -n kpartx
%_udevrulesdir/*kpartx.rules
%bindir/kpartx
%_udevdir/kpartx_id
%_man8dir/kpartx.8.*

%files -n libdmmp
%_libdir/libdmmp.so.*

%files -n libdmmp-devel
%_libdir/libdmmp.so
%dir %_includedir/libdmmp
%_includedir/libdmmp/*
%_man3dir/dmmp_*
%_man3dir/libdmmp.h.3.*
%_pkgconfigdir/libdmmp.pc

%changelog
