%def_disable snapshot

Name: mypaint
Version: 2.0.1
Release: alt2

Summary: A simple paint program
Group: Graphics
License: GPL-2.0-or-later and ISC and Public-domain
Url: http://mypaint.org/

%if_disabled snapshot
Source: https://github.com/%name/%name/releases/download/v%version/%name-%version.tar.xz
%else
# VCS: https://github.com/mypaint/mypaint
Source: %name-%version.tar
%endif

# https://github.com/mypaint/mypaint/pull/1193
Patch: 032a155b72f2b021f66a994050d83f07342d04af.patch

%define mypaintlib_ver 1.6

Requires: %name-data = %version-%release
Requires: mypaint-brushes >= 2.0
Requires: typelib(MyPaint) = 1.6

%add_python3_path %_datadir/%name %_libdir/%name

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: lib%name-devel >= %mypaintlib_ver
BuildRequires: gcc-c++ libgomp-devel swig libgtk+3-devel
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-numpy libnumpy-py3-devel
BuildRequires: libpng-devel libjson-c-devel liblcms2-devel
BuildRequires: gobject-introspection-devel python3-module-pygobject3-devel
BuildRequires: pkgconfig(mypaint-brushes-2.0)

%description
MyPaint is a simple drawing and painting program that works well with
Wacom-style graphics tablets. Its main features are a highly configurable
brush engine, speed, and a fullscreen mode which allows artists to fully
immerse themselves in their work.

%package data
Summary: A simple paint program
Group: Graphics
BuildArch: noarch

%description data
Mypaint is a fast and easy/simple painter program. It comes with a large
brush collection including charcoal and ink to emulate real media, but the
highly configurable brush engine allows you to experiment with your own
brushes and with not-quite-natural painting.

This package contains the data files needed for the program.

%package -n lib%name-devel-static
Summary: Static mypaint brush library
Group: Development/C

%description -n lib%name-devel-static
Mypaint is a fast and easy/simple painter program. It comes with a large
brush collection including charcoal and ink to emulate real media, but the
highly configurable brush engine allows you to experiment with your own
brushes and with not-quite-natural painting.

This package provides files needed for development applications statically linked
with mypaint brush library.

%add_python_lib_path %_datadir/%name

%prep
%setup
%patch -p1
# fix libdir
subst "s|prefix, 'lib'|prefix, '%_lib'|" mypaint.py

%build
%python3_build

%install
%python3_install --install-lib=%_libdir/%name
%find_lang --output=%name.lang %name

%files -f %name.lang
%_bindir/*
%_libdir/%name/

%files data
%_datadir/%name/
%_datadir/thumbnailers/%name-ora.thumbnailer
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/*/*
%_datadir/metainfo/mypaint.appdata.xml
%doc README.md Changelog.md Licenses.md

%changelog
