%define _unpackaged_files_terminate_build 1
%define icinga_user icinga

Name: 	  nagwad
Version:  0.11.6
Release:  alt1

Summary:  System journal event scanner and handler
License:  GPLv3
Group:    Monitoring
Url: 	  http://git.altlinux.org/people/manowar/packages/nagwad.git

Source:   %name-%version.tar

BuildRequires: discount libaudit-devel

%description
Daemon that continuously reads the system journal and generates events
based on journal messages. The example configuration contains
templates to pass the events further to Icinga and Nagios.

%package service
Summary: System journal event scanner and handler
Group:   Monitoring

BuildArch: noarch

Provides: %name = %version-%release
Obsoletes: %name <= 0.9.12-alt2

Requires: systemd
Requires: %name-audit = %version-%release

Conflicts: integ <= 0.4.2-alt2

%description service
Daemon that continuously reads the system journal and generates events
based on journal messages. The example configuration contains
templates to pass the events further to Icinga and Nagios.

%package nagios
Summary: Nagios templates for a nagwad node
Group:   Monitoring

Requires: %name-service = %version-%release
Requires: nagios-nrpe >= 3.2.1-alt4

Obsoletes: %name-server
Conflicts: %name-server
Conflicts: nagios < 3.0.6-alt9

Obsoletes: %name-templates
Provides: nagwad-nagios-templates = %version

BuildArch: noarch

%description nagios
These are Nagios configuration templates for monitoring a nagwad-node.

%package icinga
Summary: Icinga-2 configuration for a standalone nagwad node
Group:   Monitoring
BuildArch: noarch
Requires: %name-service
Requires: icinga2-common
Provides: nagwad-icinga-templates = %version

%description icinga
These are Icinga-2 configuration templates for monitoring using
nagwad on a standalone Icinga 2 node.

%package icinga-master
Summary: Icinga-2 master node configuration to monitor nagwad nodes
Group:   Monitoring
BuildArch: noarch
Requires: %name-service
Requires: icinga2-common
Provides: nagwad-icinga-templates = %version

%description icinga-master
These are Icinga-2 configuration templates for a master node to
be automatically distributed to Icinga 2 agents.

%package icinga-agent
Summary: Icinga-2 agent/satellite node configuration to monitor nagwad nodes
Group:   Monitoring
BuildArch: noarch
Requires: %name-service
Requires: icinga2-common
Provides: nagwad-icinga-templates = %version

%description icinga-agent
These are Icinga-2 configuration templates for a agent/satellite node.

%package icinga-push
Summary: An event post-processing script to push check results to an Icinga-2 inctance
Group:   Monitoring
BuildArch: noarch
Requires: %name-service = %version-%release

%description icinga-push
An event post-processing script to push check results to an Icinga-2
inctance (so-called passive checks). It can work without an Icinga2
agent installed on the node.

%package nagstamon
Summary: Nagstamon actions for a nagwad node
Group:   Monitoring
Requires: xvt openssh-clients
Requires: %name-service = %version-%release
Requires: nsca-shell = %version-%release

Obsoletes: %name-actions <= 0.9.14-alt1
Provides: %name-actions = %version-%release

BuildArch: noarch

%description nagstamon
These are Nagstamon action commands suitable for a nagwad-node.

%package audit
Summary: Audit rules for a nagwad node
Group:   Monitoring
Requires: audit mk-syscall-rules

BuildArch: noarch

%description audit
Contains audit rules for the 'audit' facility of %{name}.

%package -n mk-syscall-rules
Summary: A tool to generate audit rules based on a configuration file
License:  GPLv3
Group:   Monitoring
Requires: which

%description -n mk-syscall-rules
Contains 'mk-syscall-rules' and 'aunormarch' utils.

%package -n nsca-shell
Summary: A shell which sends session typescript to a Nagios server
Group:   Monitoring
BuildArch: noarch

%description -n nsca-shell
A tool to record a typescript of a terminal session
and then send it to a Nagios monitoring server in order to keep
a log of operations with a particular host or service.

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std unitdir=%_unitdir
mkdir -p %buildroot/var/log/nagwad
# Touch the file for %%ghost below.
touch %buildroot%_sysconfdir/audit/rules.d/50-nagwad-arch.rules

%pre service
getent group %name >/dev/null || %_sbindir/groupadd -r %name

if [ -e %_sysconfdir/nagwad/audit/audit.regexp ]; then
    cp -nv %_sysconfdir/nagwad/audit/audit.regexp \
       %_sysconfdir/nagwad/eperm.regexp ||:
fi
if [ -e %_sysconfdir/nagwad/audit.regexp ]; then
    cp -nv %_sysconfdir/nagwad/audit.regexp \
       %_sysconfdir/nagwad/eperm.regexp ||:
fi
if [ -e %_sysconfdir/nagwad/audit-rules.conf ]; then
    cp -nv %_sysconfdir/nagwad/audit-rules.conf \
       %_sysconfdir/nagwad/eperm-audit-rules.conf ||:
fi
if [ -e %_sysconfdir/nagwad/authdata/authdata.regexp ]; then
    cp -nv %_sysconfdir/nagwad/authdata/authdata.regexp \
       %_sysconfdir/nagwad/authdata.regexp ||:
fi
if [ -e %_sysconfdir/nagwad/device/device.regexp ]; then
    cp -nv %_sysconfdir/nagwad/device/device.regexp \
       %_sysconfdir/nagwad/device.regexp ||:
fi
if [ -e %_sysconfdir/nagwad/login/login.regexp ]; then
    cp -nv %_sysconfdir/nagwad/login/login.regexp \
       %_sysconfdir/nagwad/login.regexp ||:
fi

%post audit
_mk_syscall_rules_relax=
if [ $1 = 1 -a -d /.host -a -d /.in -a -d /.out ]; then
    _mk_syscall_rules_relax=1
fi
%_sbindir/mk-syscall-rules -v \
    ${_mk_syscall_rules_relax:+--relax} \
    -c %_sysconfdir/nagwad/eperm-audit-rules.conf

%post icinga
usermod -a -G %name %icinga_user

%post icinga-master
usermod -a -G %name %icinga_user

%post icinga-agent
usermod -a -G %name %icinga_user

%files service
%doc README.md README.html signal.md signal.html
%_sbindir/nagwad
%_man8dir/nagwad.8.*
%_unitdir/nagwad.*
%_libexecdir/nagios/plugins/*
%dir %_sysconfdir/nagwad
%config(noreplace) %_sysconfdir/nagwad/nagwad.conf
%config(noreplace) %_sysconfdir/nagwad/*.regexp
%config(noreplace) %_sysconfdir/nagwad/*.sed
%dir %_sysconfdir/nagwad/filter-event.d
%config(noreplace) %_sysconfdir/nagwad/filter-event.d/[0-9]*
%dir %_sysconfdir/nagwad/filter-event.d/eperm-skip.d
%config(noreplace) %_sysconfdir/nagwad/filter-event.d/eperm-skip.d/*.regexp
/var/log/nagwad

%files audit
%config(noreplace) %_sysconfdir/audit/rules.d/*-nagwad*-noarch.rules
%ghost %_sysconfdir/audit/rules.d/50-nagwad-arch.rules
%config(noreplace) %_sysconfdir/nagwad/eperm-audit-rules.conf

%files nagios
%config(noreplace) %_sysconfdir/nagios/templates/*nagwad*.cfg
%config(noreplace) %_sysconfdir/nagios/nrpe-commands/nagwad.cfg

%files icinga
%doc conf/icinga/nagwad.json
%config(noreplace) %_sysconfdir/icinga2/conf.d/nagwad.conf

%files icinga-master
%doc conf/icinga/nagwad.json
%config(noreplace) %_sysconfdir/icinga2/conf.d/nagwad-master.conf
%config(noreplace) %_sysconfdir/icinga2/zones.d/global-commands/*.conf

%files icinga-agent
%config(noreplace) %_sysconfdir/icinga2/conf.d/nagwad-agent.conf

%files icinga-push
%_sysconfdir/nagwad/process-event.d/10-push-icinga
%config(noreplace) %_sysconfdir/nagwad/process-event.d/push-icinga.conf

%files nagstamon
%config(noreplace) %_sysconfdir/nagstamon/actions/*.conf

%files -n mk-syscall-rules
%_bindir/aunormarch
%_sbindir/mk-syscall-rules

%files -n nsca-shell
%_bindir/nsca-shell

%changelog
