%define _unpackaged_files_terminate_build 1

#TODO: try bulding against OpenMPI only when version upgrade 2.1->3.1
%def_without openmpi
%def_with ffmpeg

%define mpiimpl openmpi-compat
%define mpidir %_libdir/%mpiimpl
%define _cmake__builddir BUILD
%define build_parallel_jobs 1

%def_without shared_togl
%define togl_ver 2.1

%set_verify_elf_method unresolved=relaxed

Name: netgen
Version: 6.2.2406
Release: alt2
Summary: Automatic 3d tetrahedral mesh generator
License: LGPLv2
Group: Sciences/Mathematics
Url: https://github.com/NGSolve/netgen
#Git: https://github.com/NGSolve/netgen.git

ExcludeArch: i586

Source: %name-%version.tar
Source1: netgen.png
Source2: netgen.desktop
Source3: netgen-parallel.desktop
Source4: submodules.tar

# Rename shared libaries (the original names are often way too generic), add library version
Patch2: netgen-6.2-alt-libs-rename-and-versions.patch
# Set a default NETGENDIR appropriate for packaging
Patch3: netgen-6.2-alt-set-default-netgendir.patch
# Make some includes relative (needed for when headers are in -private subpackage)
Patch4: 0004-Make-some-includes-relative.patch
# Make bin, lib and python sitearch installation directories configurable
Patch5: 0005-Make-bin-lib-and-pysitearch-dirs-configurable.patch
# Unbundle togl (see also %%prep)
Patch6: netgen-6.2-alt-unbundle-togl.patch
# SuperBuild.cmake fails to propagate USE_JPEG
Patch7: 0007-Add-missing-USE_JPEG-propagation.patch
# Add missing -ldl
Patch8: 0008-Add-missing-ldl.patch
Patch9: netgen-alt-nglib-link-public-libraries.patch
Patch13: netgen-alt-build-shared-togl.patch
Patch14: netgen-6.2.2406-alt-using-namespace-std-in-enconding.patch
Patch15: netgen-debian-fix-version-exception.patch

BuildRequires(pre): rpm-build-tcl
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): ccmake

BuildRequires: clang
BuildRequires: gcc-c++
BuildRequires: python3-devel
BuildRequires: opencascade-devel
BuildRequires: tk-devel
BuildRequires: libXmu-devel
BuildRequires: libavformat-devel
BuildRequires: libjpeg-devel
BuildRequires: libswresample-devel
BuildRequires: libswscale-devel
BuildRequires: pybind11-devel
BuildRequires: zlib-devel
BuildRequires: desktop-file-utils
%if_with openmpi
BuildRequires: libmetis-devel
BuildRequires: %mpiimpl-devel
%endif
%if_with shared_togl
BuildRequires: tcl-togl-devel 
%endif
BuildRequires: libGLU-devel
BuildRequires: git-core
BuildRequires: libfreetype-devel
BuildRequires: fontconfig-devel
BuildRequires: python3(setuptools)

Requires: lib%name = %EVR tcl-tix

%add_findreq_skiplist %_datadir/%name/*
%add_findprov_lib_path %_libdir/%mpiimpl/lib %_tcllibdir

%define base_description \
"NETGEN is an automatic 3d tetrahedral mesh generator. It accepts input \
from constructive solid geometry (CSG) or boundary representation (BRep) \
from STL file format. The connection to a geometry kernel allows the \
handling of IGES and STEP files. NETGEN contains modules for mesh \
optimization and hierarchical mesh refinement."

%description
%base_description

%package -n lib%name
Summary: Shared library of NETGEN
Group: System/Libraries

%description -n lib%name
%base_description

This package contains shared library of NETGEN.

%package -n python3-module-%name
Summary: Python bindings of NETGEN
Group: Development/Python3
Requires: lib%name = %EVR
Provides: python3(netgen.libngpy._NgOCC) python3(netgen.libngpy._csg) python3(netgen.libngpy._geom2d) python3(netgen.libngpy._meshing) python3(netgen.libngpy._stl)
Conflicts: python3-module-%name-openmpi

%description -n python3-module-%name
%base_description

This package contains Python bindings of NETGEN.

%package -n lib%name-devel
Summary: Development files of NETGEN
Group: Development/C++
#BuildArch: noarch
Requires: lib%name = %EVR

%description -n lib%name-devel
%base_description

This package contains development files of NETGEN.

%package doc
Summary: Documentation for NETGEN
Group: Documentation
BuildArch: noarch

%description doc
%base_description

This package contains documentation for NETGEN.

%package tutorials
Summary: Tutorials for NETGEN
Group: Documentation
BuildArch: noarch

%description tutorials
%base_description

This package contains tutorials for NETGEN.

%if_with openmpi
%package openmpi
Summary: Shared library of NETGEN built with %mpiimpl
Group: System/Libraries
%description openmpi
%base_description

%package -n lib%name-openmpi
Summary: Shared library of NETGEN
Group: System/Libraries

%description -n lib%name-openmpi
%base_description

This package contains shared library of NETGEN.

%package -n lib%name-openmpi-devel
Summary: Development files of NETGEN
Group: Development/C++
#BuildArch: noarch
Requires: lib%name-openmpi = %EVR

%description -n lib%name-openmpi-devel
%base_description

This package contains development files of NETGEN.

%package -n python3-module-%name-openmpi
Summary: Python bindings of NETGEN
Group: Development/Python3
Requires: lib%name-openmpi = %EVR
Provides: python3(netgen.libngpy._NgOCC) python3(netgen.libngpy._csg) python3(netgen.libngpy._geom2d) python3(netgen.libngpy._meshing) python3(netgen.libngpy._stl)
Conflicts: python3-module-%name

%description -n python3-module-%name-openmpi
%base_description

This package contains Python bindings of NETGEN.

%endif

%prep
%setup
tar xf %SOURCE4

#%%patch2 -p1
%patch3 -p1
%patch4 -p1
#%%patch5 -p1
%if_with shared_togl
%patch6 -p1
%else
%patch13 -p1
%endif
%patch7 -p1
#%%patch8 -p1
%patch9 -p1
%patch14 -p1
%patch15 -p1

%ifarch %e2k
sed -i "/data{_mm/{s|{|(|;s|}|)|}" libsrc/core/simd_{sse,avx}.hpp
sed -i "s|defined(__FMA__) && !defined(__AVX512F__)|& \&\& !defined(__e2k__)|" libsrc/core/simd_avx.hpp
%endif

echo -n v%version > version.txt

%if_with shared_togl
# Remove bundled togl
rm -rf ng/Togl-1.7
rm -rf ng/Togl2.1
rm -f ng/togl_1_7.h
%endif

%ifarch x86_64 aarch64
sed -i 's|@UINT64_C@|UL|' ng/ngpkg.cpp
%else
sed -i 's|@UINT64_C@|ULL|' ng/ngpkg.cpp
%endif

#repair default (R)PATHs
sed -i 's|NG_INSTALL_DIR_LIB_DEFAULT lib|NG_INSTALL_DIR_LIB_DEFAULT lib${LIB_SUFFIX}|' CMakeLists.txt
#applied for changing hardcoded "lib" in path to cmake files on value of "%%_libdir"
sed -i 's|NG_INSTALL_DIR_CMAKE_DEFAULT lib/cmake/${NG_INSTALL_SUFFIX}|NG_INSTALL_DIR_CMAKE_DEFAULT %_libdir/cmake/%name|' CMakeLists.txt

%if_without shared_togl
sed -i 's|<tkInt.h>|<tk/generic/tkInt.h>|' ng/Togl2.1/togl.c
%endif

%build
%ifarch %e2k
%add_optflags -DNETGEN_ARCH_AMD64 -Wno-return-type -Wno-sign-compare
%endif

# clang doesn't support -flto=auto
%define optflags_lto %nil

###########################################################################
###################          SERIAL VER           #########################
  OPTFLAGS="%optflags"
  CFLAGS="$OPTFLAGS -fno-strict-aliasing" \
  CXXFLAGS="$OPTFLAGS -fno-strict-aliasing" \
  %cmake \
    -DNETGEN_VERSION_GIT=%version \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DNG_INSTALL_DIR_BIN=%_bindir \
    -DNG_INSTALL_DIR_INCLUDE=%_includedir/%name \
    -DCMAKE_C_COMPILER=clang \
    -DCMAKE_CXX_COMPILER=clang++ \
    -DPython3_INCLUDE_DIR=%__python3_includedir \
    -DUSE_JPEG=1 \
    -DUSE_OCC=1 \
    -DPYBIND_INCLUDE_DIR=%_includedir \
    -DNG_INSTALL_PYBIND=OFF \
    -DLIBTOGL=%_tcllibdir/libTogl%togl_ver.so \
    -Dng_install_dir_lib=%_libdir \
    -DCMAKE_SKIP_RPATH=OFF \
    -DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
    -DCMAKE_SKIP_BUILD_RPATH=OFF \
    -DCMAKE_BUILD_WITH_INSTALL_RPATH=OFF \
    -DCMAKE_INSTALL_RPATH_USE_LINK_PATH:BOOL=FALSE \
    -DCMAKE_INSTALL_RPATH="%_tcllibdir" \
    -DNETGEN_PYTHON_RPATH="%_libdir" \
    -DPREFER_SYSTEM_PYBIND11=ON \
    -DUSE_NATIVE_ARCH=OFF \
    -DUSE_GUI=ON \
    -DUSE_PYTHON=ON \
    -DUSE_MPI=OFF \
    -DUSE_OCC=ON \
    -DUSE_JPEG=ON \
%if_with ffmpeg
    -DUSE_MPEG=ON \
%else
    -DUSE_MPEG=OFF \
%endif

export NPROCS=%build_parallel_jobs
%cmake_build

############################################################################
############################      MPI ver ##################################

%if_with openmpi
mkdir -p %mpiimpl-BUILD
pushd %mpiimpl-BUILD
mpi-selector --yes --set %mpiimpl
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath, %mpidir/lib -L%mpidir/lib"
source %mpidir/bin/mpivars.sh
export MPIDIR=%mpidir

  OPTFLAGS="%optflags"
  CFLAGS="$OPTFLAGS -fno-strict-aliasing -DOMPI_IGNORE_CXX_SEEK" \
  CXXFLAGS="$OPTFLAGS -fno-strict-aliasing -DOMPI_IGNORE_CXX_SEEK" \
  %cmake \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DNG_INSTALL_DIR_BIN=%mpidir/bin \
    -DNG_INSTALL_DIR_LIB=%mpidir/lib \
    -DNG_INSTALL_DIR_INCLUDE=%mpidir/include/%name \
    -DNG_INSTALL_DIR_CMAKE=%mpidir/lib/cmake \
    -DMETIS_INCLUDE_DIR:PATH=%_includedir/metis \
    -DUSE_JPEG=1 \
    -DUSE_OCC=1 \
    -DPYBIND_INCLUDE_DIR=%_includedir \
    -DNG_INSTALL_PYBIND=OFF \
    -DLIBTOGL=%_tcllibdir/libTogl%togl_ver.so \
    -Dng_install_dir_lib=%_libdir \
    -DCMAKE_SKIP_RPATH=OFF \
    -DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
    -DCMAKE_SKIP_BUILD_RPATH=OFF \
    -DCMAKE_BUILD_WITH_INSTALL_RPATH=OFF \
    -DCMAKE_INSTALL_RPATH_USE_LINK_PATH:BOOL=FALSE \
    -DCMAKE_INSTALL_RPATH="%mpidir/lib:%_tcllibdir" \
    -DNETGEN_PYTHON_RPATH=%_libdir \
    -DUSE_NATIVE_ARCH=OFF \
    -DUSE_GUI=ON \
    -DUSE_PYTHON=ON \
    -DNG_INSTALL_DIR_PYTHON=%python3_sitelibdir \
    -DUSE_MPI=ON \
    -DUSE_OCC=ON \
    -DUSE_JPEG=ON \
%if_with ffmpeg
    -DUSE_MPEG=ON \
%else
    -DUSE_MPEG=OFF \
%endif 
    ../..

%cmake_build VERBOSE=1
popd
%endif #openmpi

%install

sed -i 's|file(INSTALL DESTINATION "%_prefix/include/netgen/pybind11" TYPE FILE FILES "/usr/include/../LICENSE")||' BUILD/netgen/cmake_install.cmake

#installing serial version
%cmakeinstall_std NETGENDIR=%_bindir TCLLIBDIR=%_tcllibdir LIBTOGL=%_tcllibdir/libTogl%togl_ver.so TOPDIR=$PWD
%add_findreq_skiplist %_datadir/%name/py_tutorials/*.py
%add_findprov_skiplist %_datadir/%name/py_tutorials/*.py

# Install icon and desktop file
install -Dpm 0644 %SOURCE1 %buildroot%_iconsdir/hicolor/48x48/apps/%name.png
desktop-file-install --dir %buildroot%_datadir/applications/ %SOURCE2

%if_with openmpi
export MPIDIR=%mpidir
#installing OpenMPI version
pushd %mpiimpl-BUILD
%cmakeinstall_std NETGENDIR=%_bindir TCLLIBDIR=%_tcllibdir LIBTOGL=%_tcllibdir/libTogl%togl_ver.so TOPDIR=$PWD
popd

# Install parallel desktop file
desktop-file-install --dir %buildroot%_datadir/applications/ %SOURCE3
sed -i 's|Exec=mpirun|Exec=%mpidir/bin/mpirun|' %buildroot%_datadir/applications/netgen-parallel.desktop
%endif

rm -rf %buildroot%_includedir/netgen/pybind11
rm -rf %buildroot%_datadir/%name/doc

%files
%doc AUTHORS
%_datadir/icons/hicolor/48x48/apps/%name.png
%_datadir/applications/*.desktop
%_bindir/*

%files -n lib%name
%_libdir/*.so*

%files -n lib%name-devel
%_includedir/*
%_libdir/cmake/%name/*.cmake

%files doc
%doc doc/ng4.pdf

%files tutorials
%_datadir/%name

%files -n python3-module-%name
%python3_sitelibdir/*

%if_with openmpi
%files openmpi
%mpidir/bin/*

%files -n lib%name-openmpi
%mpidir/lib/*.so*

%files -n lib%name-openmpi-devel
%mpidir/lib/cmake/*.cmake

%files -n python3-module-%name-openmpi
%python3_sitelibdir/*
%endif #openmpi

%changelog
