Name: nextcloud-client
Version: 3.15.2
Release: alt1
%K6init no_altplace

Group: Networking/File transfer
Summary: Nextcloud Desktop Client
License: GPLv2
Url: https://github.com/nextcloud/desktop

Provides: mirall = %version-%release
Obsoletes: mirall <= %version-%release

Provides: nextcloud-desktop = %version-%release

Source0: %name-%version.tar
Source2: nextcloud-client.desktop
Patch1: alt-dont-check-updates.patch
Patch2: alt-confdir.patch
Patch3: alt-static-libs.patch
Patch4: %name-2.3.3-alt-fix-help-url.patch
Patch5: alt-move-deleted-to-trash.patch
Patch6: alt-fix-fortify-source.patch

%add_python3_path %_datadir/caja-python/extensions
%add_python3_path %_datadir/nautilus-python/extensions
%add_python3_path %_datadir/nemo-python/extensions

BuildRequires(pre): rpm-macros-qt6-webengine rpm-build-python3 rpm-build-gir
BuildRequires(pre): rpm-build-kf6
BuildRequires: doxygen extra-cmake-modules graphviz libsqlite3-devel libssl-devel python3-dev zlib-devel
BuildRequires: qt6-declarative-devel qt6-tools-devel qt6-svg-devel qt6-websockets-devel qt6-5compat-devel
BuildRequires: libqtkeychain-qt6-devel
BuildRequires: kf6-kwindowsystem-devel kf6-karchive-devel kf6-kio-devel
%ifarch %qt6_qtwebengine_arches
BuildRequires: libqt6-webenginewidgets qt6-webengine-devel
%endif
BuildRequires: libvulkan-devel
BuildRequires: libgio-devel glib2-devel
BuildRequires: /usr/bin/rsvg-convert

%description
The Nextcloud Desktop Client is a tool to synchronize files from Nextcloud Server with your computer.

%package kde
Summary: KDE %name integration
Group: Graphical desktop/KDE
Requires: %name
Provides:  nextcloud-client-kde5 = %EVR
Obsoletes: nextcloud-client-kde5 < %EVR
%description kde
KDE %name integration

%package mate
Summary: MATE %name integration
Group: Graphical desktop/MATE
Requires: %name
Requires: python3-module-caja
BuildArch: noarch

%description mate
MATE %name integration

%package gnome
Summary: GNOME %name integration
Group: Graphical desktop/GNOME
Requires: %name
Requires: nautilus-python
BuildArch: noarch

%description gnome
GNOME %name integration

%package cinnamon
Summary: Cinnamon %name integration
Group: Graphical desktop/Other
Requires: %name
Requires: nemo-python
BuildArch: noarch

%description cinnamon
Cinnamon %name integration

%prep
%setup
%patch6 -p1

%build
%add_optflags %optflags_shared
%K6build \
    -DQT_MAJOR_VERSION=6 \
%ifarch %not_qt6_qtwebengine_arches
    -DBUILD_WITH_WEBENGINE=OFF \
%endif
    -DDATA_INSTALL_DIR=%_datadir \
    -DCMAKE_INSTALL_SYSCONFDIR=/etc/%name \
    -DKDE_INSTALL_PLUGINDIR=%_K6plug \
    -DCMAKE_BUILD_TYPE=Release \
    -DNO_SHIBBOLETH=1

%install
%K6install
mkdir -p %buildroot/%_desktopdir
desktop-file-install \
    --dir=%buildroot/%_desktopdir %SOURCE2
#cd %buildroot/%_libdir
#ln -s nextcloud/libocsync.so.%version libocsync.so.0; cd ../..
%find_lang --with-qt --with-man client

%files -f client.lang
%doc README.md
%dir %_datadir/nextcloud
%dir %_datadir/nextcloud/i18n
%dir %_sysconfdir/Nextcloud
%config(noreplace) %_sysconfdir/Nextcloud/sync-exclude.lst
%_bindir/nextcloud
%_bindir/nextcloudcmd
%_libdir/*nextcloud*.*
%_desktopdir/*.desktop
%_datadir/mime/packages/nextcloud.xml
%_iconsdir/hicolor/*/apps/Nextcloud.*
%_iconsdir/hicolor/*/apps/Nextcloud_*.*

%files kde
%_K6plug/kf6/overlayicon/
%_K6plug/kf6/kfileitemaction/
#%_K6srv/*nextcloud*.desktop

%files mate
%_datadir/caja-python/extensions/*.py
%_datadir/caja-python/extensions/__pycache__/*

%files gnome
%_datadir/nautilus-python/extensions/*.py
%_datadir/nautilus-python/extensions/__pycache__/*

%files cinnamon
%_datadir/nemo-python/extensions/*.py
%_datadir/nemo-python/extensions/__pycache__/*

%changelog
