%define _unpackaged_files_terminate_build 1

%def_without shared_togl
%def_without unittests

Name: ngsolve
Version: 6.2.2406
Release: alt1
Summary: NGSolve Finite Element Library
License: LGPL-2.1
Group: Sciences/Mathematics
Url: https://github.com/NGSolve/ngsolve

ExclusiveArch: x86_64

# https://github.com/NGSolve/ngsolve.git
Source: %name-%version.tar

Patch1: %name-alt-version-detection.patch
Patch2: %name-alt-return-type.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: OCE-devel
BuildRequires: doxygen
BuildRequires: libXmu-devel
BuildRequires: libavformat-devel
BuildRequires: libjpeg-devel
BuildRequires: liblapack-devel
BuildRequires: libswscale-devel
BuildRequires: pybind11-devel
BuildRequires: python3-devel
BuildRequires: libnetgen-devel
BuildRequires: netgen
BuildRequires: python3-module-netgen
%if_with shared_togl
BuildRequires: tcl-togl-devel
%endif

%add_findreq_skiplist %_datadir/%name/py_tutorials/*.py
%add_python3_req_skip petsc4py.PETSc webgui_jupyter_widgets webgui_jupyter_widgets.widget

%define base_description \
NGSolve is a general purpose Finite Element Library on top of Netgen. \
With the basic library one can solve heat flow equations, Maxwell \
equations, and solid mechanical problems. Several add-ons are available \
for particular application classes.

%description %base_description

%package -n lib%name
Summary: Shared libraries of NGSolve
Group: System/Libraries
%py_provides ngslib

%description -n lib%name %base_description

This package contains shared libraries of NGSolve.

%package -n lib%name-devel
Summary: Development files of NGSolve
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel %base_description

This package contains development files of NGSolve.

%package -n python3-module-%name
Summary: Python module of NGSolve
Group: Development/Python
Requires: lib%name = %EVR
Provides: python3(ngsolve.bla) python3(ngsolve.comp) python3(ngsolve.fem) python3(ngsolve.la) python3(ngsolve.ngstd) python3(ngsolve.solve)
Conflicts: python3-module-%name-openmpi

%description -n python3-module-%name %base_description

This package contains Python module of NGSolve.

%package demos
Summary: Demos for NGSolve
Group: Development/Documentation
Requires: lib%name = %EVR
%add_python_req_skip fem

%description demos %base_description

This package contains demos for NGSolve.

%package docs
Summary: Documentation for NGSolve
Group: Development/Documentation
BuildArch: noarch

%description docs %base_description

This package contains development documentation for NGSolve.

%prep
%setup
%patch1 -p1
%patch2 -p1

echo -n v%version > version.txt

%build
%add_optflags -fno-strict-aliasing -Wno-sign-compare -Wno-maybe-uninitialized -Wno-literal-suffix -Wno-error=return-type

%cmake \
	-DNGSOLVE_INSTALL_DIR_CMAKE=%_prefix \
	-DUSE_SUPERBUILD=OFF \
	-DUSE_MPI=OFF \
	-DUSE_LAPACK=ON \
	-DUSE_VT=OFF \
	-DUSE_MKL=OFF \
	-DUSE_HYPRE=OFF \
	-DUSE_MUMPS=OFF \
	-DUSE_PARDISO=OFF \
	-DUSE_UMFPACK=OFF \
	-DINTEL_MIC=OFF \
	-DUSE_VTUNE=OFF \
	-DUSE_NUMA=OFF \
	-DUSE_CCACHE=OFF \
	-DINSTALL_DEPENDENCIES=OFF \
%if_with unittests
	-DENABLE_UNIT_TESTS=ON \
%endif
	%nil

%cmake_build

doxygen

%install
%cmakeinstall_std

sed -i "s|/usr/bin/bash|/bin/bash|" %buildroot%_bindir/ngscxx
sed -i "s|/usr/bin/bash|/bin/bash|" %buildroot%_bindir/ngsld

%files
%_bindir/ngsolve.tcl
%_datadir/%name

%files -n lib%name
%_libdir/*.so

%files -n lib%name-devel
%_libdir/cmake/%name
%_includedir/*

%files demos
%_bindir/*
%exclude %_bindir/ngsolve.tcl

%files docs
%doc doxy/html

%files -n python3-module-%name
%python3_sitelibdir/%name
%python3_sitelibdir/%name-py3.egg-info

%changelog
