%def_enable snapshot
%define ver_major 8.0

Name: noise
%define _name music
%define xdg_name org.pantheon.%name
%define rdn_name io.elementary.%_name
Version: %ver_major.0
Release: alt1

Summary: The official elementary music player
Group: Sound
License: LGPL-3.0-or-later
Url: https://elementary.io

Vcs: https://github.com/elementary/music.git

%if_disabled snapshot
Source: https://launchpad.net/%name/%{ver_major}.x/%version/+download/%name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

Provides: %rdn_name = %EVR
Provides: elementary-%_name = %EVR

%define gst_api_ver 1.0
%define adw_ver 1.4

Requires: elementary-icon-theme
# gstreamer
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools
BuildRequires: pkgconfig(granite-7)
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(gstreamer-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-pbutils-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-tag-%gst_api_ver)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
Quickly queue up and listen to your local music files without any extra
frills. See embedded album artwork. Control playback with media keys or
in the system audio indicator.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --output=%name.lang %rdn_name

%check
%__meson_test

%files -f %name.lang
%_bindir/%rdn_name
%_desktopdir/%rdn_name.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/apps/%rdn_name.svg
%_datadir/metainfo/%rdn_name.metainfo.xml

%changelog
