%define ocamlmod fileutils
Name: ocaml-%ocamlmod
Version: 0.6.6
Release: alt1
Summary: OCaml library for common file and filename operations
Group: Development/ML
License: LGPLv2.1 with OCaml-LGPL-linking-exception
VCS: https://github.com/gildor478/ocaml-fileutils
Url: https://forge.ocamlcore.org/projects/ocaml-fileutils/
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: ocaml dune ocaml-ounit-devel

%description
This library is intended to provide a basic interface to the most
common file and filename operations.  It provides several different
filename functions: reduce, make_absolute, make_relative...  It also
enables you to manipulate real files: cp, mv, rm, touch...

It is separated into two modules: SysUtil and SysPath.  The first one
manipulates real files, the second one is made for manipulating
abstract filenames.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup
%patch0 -p1

%build
sed -i '/stdlib-shims/d;/seq/d' *.opam
sed -i 's/stdlib-shims//;s/seq//' *.opam src/lib/fileutils/dune test/dune
%dune_build -p %ocamlmod

%install
%dune_install %ocamlmod

%check
%dune_check

%files -f ocaml-files.runtime

%files devel -f ocaml-files.devel
%doc LICENSE.txt CHANGES.md README.md

%changelog
