%def_with check
Name: ocaml-gapi
Version: 0.4.5
Release: alt2
Summary: A simple OCaml client for Google Services
License: MIT
Group: Development/ML
Url: https://github.com/astrada/gapi-ocaml
Source0: %name-%version.tar
BuildRequires: ocaml >= 4.08
BuildRequires: dune 
BuildRequires: ocaml-cryptokit-devel >= 1.11
BuildRequires: ocaml-yojson-devel >= 1.3.3
BuildRequires: ocaml-cppo
BuildRequires: ocaml-camlp-streams-devel
%if_with check
BuildRequires: ocaml-ounit-devel >= 2.0.0
BuildRequires: libcurl-devel
%endif
BuildRequires: ocaml-curl-devel
BuildRequires: zlib-devel

%description
**gapi-ocaml** is a simple, unofficial, OCaml client for Google Services. The
library supports ClientLogin, OAuth 1.0a, and OAuth 2.0 authentication.
Supported RESTful APIs:

    Calendar APIs v3
    Google+ API v1
    Tasks API v1
    APIs Discovery Service v1
    URL Shortener API v1
    OAuth2 API v2
    Custom Search API v1
    Google Analytics API v3
    Page Speed Online API v1
    Blogger API v2
    Site Verification API v1
    AdSense Management API v1.1
    BigQuery API v2
    Drive API v2
    Drive API v3
    Gmail API v1

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name%{?_isa} = %version-%release

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
sed -i 's,oUnit,ounit2,' src/test/dune
%dune_build -p gapi-ocaml

%install
%dune_install -p gapi-ocaml

%check
%dune_check -p gapi-ocaml

%files -f ocaml-files.runtime
%doc README.md LICENSE

%files devel -f ocaml-files.devel

%changelog
