%define ocamlmod ppx_expect
Name: ocaml-%ocamlmod
Version: 0.17.2
Release: alt1
Summary: a cram like framework for OCaml
Group: Development/ML
License: MIT
Url: https://github.com/janestreet/ppx_expect
VCS: https://github.com/janestreet/ppx_expect
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: ocaml >= 5.2.0
BuildRequires: ocaml-ppxlib-devel
BuildRequires: ocaml-stdio-devel
BuildRequires: ocaml-ppx_inline_test-devel >= 0.17.0
BuildRequires: ocaml-ppx_here-devel
BuildRequires: ocaml-re-devel
BuildRequires: ocaml-base-devel
BuildRequires: dune

%description
Expect-test is a framework for writing tests in OCaml, similar to Cram.
Expect-tests mimic the existing inline tests framework with the let%%expect_test
construct. The body of an expect-test can contain output-generating code,
interleaved with %%expect extension expressions to denote the expected output.

%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup
%patch0 -p1

%build
%dune_build -p %ocamlmod

%install
%dune_install %ocamlmod

# tests is broken in upstream
#check
#dune_check -p %ocamlmod

%files -f ocaml-files.runtime
%doc LICENSE.md

%files devel -f ocaml-files.devel
%doc README.mdx CHANGES.md

%changelog
