%def_without kde
%def_without gnome

Name: openbox
Version: 3.6.1
Release: alt7

Summary: Openbox is a standards compliant, fast, light-weight, extensible window manager
Summary(ru_RU.UTF-8): Openbox это следующий стандартам, быстрый, лёгкий, расширяемый оконный менеджер
License: GPLv2+
Group: Graphical desktop/Other
Url: http://openbox.org/

Source0: %name-%version.tar
Source2: %name-icons.tar.bz2
Source3: %name.menu
Source4: %name.menu-method
Source5: %name.wmsession
Source6: %name-kde.wmsession
Source7: %name-gnome.wmsession

# Debian
Source12: gnome-panel-control.pod
Source13: menu.xml

# ALT Linux
Patch2: openbox-alt-menu-rc.xml.in.patch

# Fedora
Patch10: openbox-python3.patch
Patch11: openbox-calc-layer.patch

Requires: lib%name = %version-%release
# for menu "Run" item
Requires: Xdialog

Requires: %_bindir/openbox-session
Requires: %name-themes
Requires: %_libexecdir/openbox-autostart
Requires: menu

Conflicts: openbox-extras

BuildPreReq: gettext >= 0.15

# Automatically added by buildreq on Fri Sep 11 2015 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glib2-devel libICE-devel libX11-devel libXau-devel libXext-devel libXft-devel libXrender-devel libfreetype-devel libstartup-notification libxcb-devel perl-Encode perl-Pod-Escapes perl-Pod-Simple perl-Pod-Usage pkg-config python-base rpm-build-gir xorg-kbproto-devel xorg-randrproto-devel xorg-renderproto-devel xorg-xextproto-devel xorg-xproto-devel xz
BuildRequires: imake libSM-devel libXcursor-devel libXinerama-devel libXrandr-devel libpango-devel libstartup-notification-devel libxml2-devel perl-podlators xorg-cf-files
BuildRequires: pkgconfig(librsvg-2.0)
BuildRequires: pkgconfig(imlib2)

BuildRequires: perl-podlators
BuildRequires(pre): rpm-build-python3

%description
Openbox is a standards compliant, fast, light-weight, extensible window manager.
Openbox works with your applications, and makes your desktop easier to manage.
This is because the approach to its development was the opposite of what seems
to be the general case for window managers. Openbox was written first to comply
with standards and to work properly. Only when that was in place did the team
turn to the visual interface.
Openbox is fully functional as a stand-alone working environment, or can be
usedas a drop-in replacement for the default window manager in the GNOME or KDE
desktop environments.

%package -n lib%name
Summary: Openbox libraries
Group: System/Libraries
Requires: %_datadir/themes/Clearlooks/openbox-3/themerc
Conflicts: openbox-base <= 3.5.0-alt5

%description -n lib%name
This package contains libraries for Openbox window manager:
libobparser - Openbox config file parsing library,
libobrender - Openbox Render Library.

%package -n lib%name-devel
Summary: Development files for Openbox
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the header files and libraries for
developing with Openbox window manager.

%package -n lib%name-devel-static
Summary: Development static library for Openbox
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains static libraries for developing with
Openbox window manager.

%package base
Summary: Openbox pure WM
Group: Graphical desktop/Other

%add_findreq_skiplist %_sysconfdir/menu-methods/*

%description base
Openbox pure WM.

%if_with kde
%package kde
Summary: Run KDE with Openbox as the WM
Group: Graphical desktop/Other
BuildArch: noarch
Requires: %_bindir/openbox

%description kde
Run KDE with Openbox as the WM.
%endif

%if_with gnome
%package gnome
Summary: Run GNOME with Openbox as the WM
Group: Graphical desktop/Other
Requires: %_bindir/openbox

%description gnome
Run GNOME with Openbox as the WM.
%endif

%package autostart
Summary: XDG support for Openbox
Group: Graphical desktop/Other
BuildArch: noarch
%py3_requires xdg

%description autostart
XDG support for Openbox.

%package themes
Summary: A Openbox themes engine
Group: System/Libraries
BuildArch: noarch
Requires: %_datadir/themes/Artwiz-boxed/openbox-3/themerc
Requires: %_datadir/themes/Bear2/openbox-3/themerc
Requires: %_datadir/themes/Clearlooks/openbox-3/themerc
Requires: %_datadir/themes/Clearlooks-3.4/openbox-3/themerc
Requires: %_datadir/themes/Clearlooks-Olive/openbox-3/themerc
Requires: %_datadir/themes/Mikachu/openbox-3/themerc
Requires: %_datadir/themes/Natura/openbox-3/themerc
Requires: %_datadir/themes/Onyx/openbox-3/themerc
Requires: %_datadir/themes/Onyx-Citrus/openbox-3/themerc
Requires: %_datadir/themes/Orang/openbox-3/themerc
Requires: %_datadir/themes/Syscrash/openbox-3/themerc
Conflicts: openbox-base <= 3.5.0-alt5

%description themes
This is a virtual package requires all themes engine
distributed with Openbox.

%package theme-Artwiz-boxed
Summary: A Openbox theme engine - Artwiz-boxed
Summary(ru_RU.UTF-8): Тема для Openbox - Artwiz-boxed
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Artwiz-boxed
This package contains the Openbox theme engine named Artwiz-boxed.
This theme distributed with Openbox.

%package theme-Bear2
Summary: A Openbox theme engine - Bear2
Summary(ru_RU.UTF-8): Тема для Openbox - Bear2
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Bear2
This package contains the Openbox theme engine named Bear2.
This theme distributed with Openbox.

%package theme-Clearlooks
Summary: A Openbox theme engine - Clearlooks
Summary(ru_RU.UTF-8): Тема для Openbox - Clearlooks
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Clearlooks
This package contains the Openbox theme engine named Clearlooks.
This theme distributed with Openbox.

%package theme-Clearlooks-3.4
Summary: A Openbox theme engine - Clearlooks-3.4
Summary(ru_RU.UTF-8): Тема для Openbox - Clearlooks-3.4
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Clearlooks-3.4
This package contains the Openbox theme engine named Clearlooks-3.4.
This theme distributed with Openbox.

%package theme-Clearlooks-Olive
Summary: A Openbox theme engine - Clearlooks-Olive
Summary(ru_RU.UTF-8): Тема для Openbox - Clearlooks-Olive
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Clearlooks-Olive
This package contains the Openbox theme engine named Clearlooks-Olive.
This theme distributed with Openbox.

%package theme-Mikachu
Summary: A Openbox theme engine - Mikachu
Summary(ru_RU.UTF-8): Тема для Openbox - Mikachu
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Mikachu
This package contains the Openbox theme engine named Mikachu.
This theme distributed with Openbox.

%package theme-Natura
Summary: A Openbox theme engine - Natura
Summary(ru_RU.UTF-8): Тема для Openbox - Natura
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Natura
This package contains the Openbox theme engine named Natura.
This theme distributed with Openbox.

%package theme-Onyx
Summary: A Openbox theme engine - Onyx
Summary(ru_RU.UTF-8): Тема для Openbox - Onyx
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Onyx
This package contains the Openbox theme engine named Onyx.
This theme distributed with Openbox.

%package theme-Onyx-Citrus
Summary: A Openbox theme engine - Onyx-Citrus
Summary(ru_RU.UTF-8): Тема для Openbox - Onyx-Citrus
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Onyx-Citrus
This package contains the Openbox theme engine named Onyx-Citrus.
This theme distributed with Openbox.

%package theme-Orang
Summary: A Openbox theme engine - Orang
Summary(ru_RU.UTF-8): Тема для Openbox - Orang
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Orang
This package contains the Openbox theme engine named Orang.
This theme distributed with Openbox.

%package theme-Syscrash
Summary: A Openbox theme engine - Syscrash
Summary(ru_RU.UTF-8): Тема для Openbox - Syscrash
Group: Graphical desktop/Other
BuildArch: noarch
Conflicts: openbox-base <= 3.5.0-alt5

%description theme-Syscrash
This package contains the Openbox theme engine named Syscrash.
This theme distributed with Openbox.

%prep
%setup -q -a2
%autopatch -p1

sed -i '/^obrender_libobrender_la_LIBADD/ a\\tobt/libobt.la \\' Makefile.am

%build
%autoreconf
%configure \
	--disable-rpath \
	--disable-static
%make_build

cp %SOURCE12 .

pod2man --section=1 --release=%version --center "Openbox documentation" gnome-panel-control.pod > gnome-panel-control.1

%install
%make_install DESTDIR=%buildroot install

rm -rf %buildroot%_datadir/doc/

# manual pages
mkdir -p %buildroot%_man1dir/
install -pD -m 644 gnome-panel-control.1 %buildroot%_man1dir/

# icons
install -pD -m 644 %name-64.xpm %buildroot%_iconsdir/hicolor/64x64/apps/OpenBox.xpm
install -pD -m 644 %name-48.xpm %buildroot%_liconsdir/%name.xpm
install -pD -m 644 %name-32.xpm %buildroot%_niconsdir/%name.xpm
install -pD -m 644 %name-16.xpm %buildroot%_miconsdir/%name.xpm

# Menu isn't cooked yet, because it's hard to implement menu-method
# for Openbox XML based menu
install -pD -m 755 %SOURCE4 %buildroot%_sysconfdir/menu-methods/%name
install -pD -m 644 %SOURCE5 %buildroot%_sysconfdir/X11/wmsession.d/09%name
%if_with kde
install -pD -m 644 %SOURCE6 %buildroot%_sysconfdir/X11/wmsession.d/10%name-kde
%endif
install -pD -m 644 %SOURCE7 %buildroot%_sysconfdir/X11/wmsession.d/11%name-gnome

mkdir -p %buildroot%_sysconfdir/xdg/openbox/

install -pD -m 644 %SOURCE13 %buildroot%_sysconfdir/xdg/openbox/

%find_lang --output=%name.lang %name

%files
%config %_sysconfdir/X11/wmsession.d/09openbox
%_datadir/xsessions/openbox.desktop
%_bindir/openbox-session

%files base -f %name.lang
%doc AUTHORS CHANGELOG COMPLIANCE README
%doc data/menu.xsd doc/rc-mouse-focus.xml data/rc.xsd data/xbm
%_sysconfdir/xdg/openbox/*
%config(noreplace) %_sysconfdir/menu-methods/*
%_bindir/*
%exclude %_bindir/openbox-session
%exclude %_bindir/openbox-kde-session
%exclude %_bindir/openbox-gnome-session
%exclude %_bindir/gdm-control
%exclude %_bindir/gnome-panel-control
%_man1dir/*
%exclude %_man1dir/openbox-kde-session.*
%exclude %_man1dir/openbox-gnome-session.*
%exclude %_man1dir/gnome-panel-control.*
%_datadir/gnome/wm-properties/*
%_datadir/pixmaps/*
%_liconsdir/%name.xpm
%_niconsdir/%name.xpm
%_iconsdir/hicolor/64x64/apps/OpenBox.xpm
%_miconsdir/%name.xpm
%_datadir/applications/openbox.desktop

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_pkgconfigdir/*
%_libdir/*.so
%_includedir/*

%if_with kde
%files kde
%config %_sysconfdir/X11/wmsession.d/10openbox-kde
%_bindir/openbox-kde-session
%_datadir/xsessions/openbox-kde.desktop
%_man1dir/openbox-kde-session.*
%endif

%if_with gnome
%files gnome
%config %_sysconfdir/X11/wmsession.d/11openbox-gnome
%_bindir/openbox-gnome-session
%_bindir/gdm-control
%_bindir/gnome-panel-control
%_datadir/gnome-session/sessions/openbox-gnome*.session
%_datadir/xsessions/openbox-gnome.desktop
%_man1dir/openbox-gnome-session.*
%_man1dir/gnome-panel-control.*
%endif

%files autostart
%_libexecdir/openbox-xdg-autostart
%_libexecdir/openbox-autostart

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files themes

%files theme-Artwiz-boxed
%_datadir/themes/Artwiz-boxed

%files theme-Bear2
%_datadir/themes/Bear2

%files theme-Clearlooks
%_datadir/themes/Clearlooks

%files theme-Clearlooks-3.4
%_datadir/themes/Clearlooks-3.4

%files theme-Clearlooks-Olive
%_datadir/themes/Clearlooks-Olive

%files theme-Mikachu
%_datadir/themes/Mikachu

%files theme-Natura
%_datadir/themes/Natura

%files theme-Onyx
%_datadir/themes/Onyx

%files theme-Onyx-Citrus
%_datadir/themes/Onyx-Citrus

%files theme-Orang
%_datadir/themes/Orang

%files theme-Syscrash
%_datadir/themes/Syscrash

%changelog
