%define _unpackaged_files_terminate_build 1
%define soname 7.9

Name: opencascade
Version: 7.9.0
Release: alt1

Summary: SDK for development applications dealing with 3D CAD data
License: LGPL-2.1-only-with-OCCT-exception-1.0
Group: Development/Tools
Url: http://www.opencascade.org
VCS: https://git.dev.opencascade.org/repos/occt.git

# Upstream requires a login to download sources. 
# https://dev.opencascade.org/release
# VCS: https://git.dev.opencascade.org/repos/occt.git
Source: %name-%version.tar
Patch1: opencascade-cmake.patch
Patch2: opencascade-alt-arm-build.patch
Patch2000: opencascade-e2k-disable-fenv.patch

Requires: libopencascade%soname = %EVR
Requires: opencascade-data = %EVR

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): rpm-macros-vtk
BuildRequires: doxygen
BuildRequires: fontconfig-devel
BuildRequires: gcc-c++
BuildRequires: graphviz
BuildRequires: java-devel-default
BuildRequires: libGL-devel
BuildRequires: libGLU-devel
BuildRequires: libX11-devel
BuildRequires: libXext-devel
BuildRequires: libXi-devel
BuildRequires: libXmu-devel
BuildRequires: libcoin3d-devel
BuildRequires: libfltk-devel
BuildRequires: libfreeimage-devel
BuildRequires: libfreetype-devel
BuildRequires: libftgl-devel
BuildRequires: libgl2ps-devel
BuildRequires: libvtk-devel
BuildRequires: tcl-devel
BuildRequires: tcl-tix
BuildRequires: tk-devel
BuildRequires: zlib-devel

%description
Open CASCADE Technology (OCCT) is a suite for 3D surface and solid
modeling, visualization, data exchange and rapid application development. It
is an excellent platform for development of numerical simulation software
including CAD/CAM/CAE, AEC and GIS, as well as PDM applications.

%package -n libopencascade%soname
Summary: Shared libraries of Open CASCADE
Group: System/Libraries

%description -n libopencascade%soname
Shared libraries of Open CASCADE, development platform for 3D modeling and
numerical simulation applications.

%package devel
Summary: Development files for Open CASCADE Technology
Group: Development/C++
Requires: libopencascade%soname = %EVR
Provides: OCE-devel = %EVR
Obsoletes: OCE-devel < %EVR

%description devel
Development files for Open CASCADE Technology, development platform for 3D
modeling and numerical simulation applications.

%package data
Summary: Data for Open CASCADE
Group: Development/Tools
BuildArch: noarch

%description data
This package contains data and resources for Open CASCADE.

%package samples
Summary: Samples for Open CASCADE
Group: Development/Documentation
BuildArch: noarch

%description samples
This package contains samples for Open CASCADE.

%package doc
Summary: Documentation for Open CASCADE
Group: Development/Documentation
BuildArch: noarch

%description doc
This package contains documentation for Open CASCADE.

%prep
%setup
%patch1 -p1
%ifarch %arm
%patch2 -p2
%endif
%ifarch %e2k
%patch2000 -p1
%endif

%build
# opencascade does some manual install trickery that does not respect DESTDIR.
# Make DESTDIR and environment variable that can be passed into the CMake config.
export DESTDIR="%buildroot"
%cmake_insource -GNinja \
       -DCMAKE_BUILD_TYPE=RelWithDebInfo \
       -DUSE_TBB=False \
       -DUSE_VTK=True \
       -DINSTALL_DIR_DOC=%_datadir/doc/opencascade \
       -D3RDPARTY_VTK_INCLUDE_DIR=%_includedir/vtk-%vtk_version \
       -DINSTALL_DIR_LIB=%_lib \
       -DINSTALL_DIR_CMAKE=%_lib/cmake/opencascade
%ninja_build

%install
%ninja_install
mv %buildroot%_bindir/DRAWEXE-* %buildroot%_bindir/DRAWEXE

# Remove installed files with licenses
rm -f /usr/share/doc/opencascade/*

%files
%_bindir/DRAWEXE
%_bindir/ExpToCasExe
%_bindir/ExpToCasExe-%version

%files -n libopencascade%soname
%_libdir/*.so.%soname
%_libdir/*.so.%version

%files devel
%_bindir/*.sh
%_libdir/*.so
%_includedir/*
%_libdir/cmake/opencascade

%files data
%_datadir/opencascade
%exclude %_datadir/opencascade/samples

%files samples
%_datadir/opencascade/samples

%files doc
%_datadir/doc/opencascade

%changelog
