%define _unpackaged_files_terminate_build 1

%def_with check

Name: openorienteering-mapper
Version: 0.9.5
Release: alt7

Summary: OpenOrienteering Mapper program for orienteering mapmaking
License: GPLv3
Group: Graphics

Url: http://www.openorienteering.org/apps/mapper/
#Source: https://github.com/OpenOrienteering/mapper.git
Source: %name-%version.tar

BuildRequires: ccmake
BuildRequires: doxygen
BuildRequires: gdal
BuildRequires: libcups-devel
BuildRequires: libgdal-devel
BuildRequires: libpolyclipping-devel
BuildRequires: libproj-devel
BuildRequires: qt5-location-devel
BuildRequires: qt5-sensors-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-serialport-devel
BuildRequires: sqlite3
BuildRequires: libsqlite3-devel
BuildRequires: libtiff-devel
BuildRequires: zlib-devel
%if_with check
BuildRequires: ctest
%endif

#brings gdal libs and licensing information for help menu
Requires: gdal
#provides owner for %%_iconsdir/hicolor subtree
Requires: icon-theme-hicolor
Requires: qt5-assistant

%description
 OpenOrienteering Mapper is an orienteering mapmaking program and provides a
 free alternative to the existing proprietary solution. Its main advantages
 compared to it are:
 Open Source: The program is completely free, every programmer can improve it.
 Cross-platform: The program works on Android, Windows, macOS and Linux.
While it is under continuous development and considered in beta state, it has
been used to produce maps for classical orienteering, MTBO and radio
orienteering races. All required functions for drawing maps are implemented and
the program works very stable. So it  can be considered ready for productive
use, although it is like always a good idea to keep backups of your files. We
are happy about feedback to the program.

%prep
%setup
%ifarch %e2k
# workaround for a bug in the EDG frontend 
sed -i '/\[\](/{N;/Symbol::duplicate/s|\[\]|[this]|}' \
	src/core/symbols/{combined,point}_symbol.cpp
%endif

#provide licensing information search path patterns specific for Altlinux
cp doc/licensing/fedora-licensing.cmake doc/licensing/altlinux-licensing.cmake
sed -i 's|doc\/\(.*\)-libs|\1|g' doc/licensing/altlinux-licensing.cmake

#fix qt assistant search by default paths
sed -i 's|"assistant"|"assistant-qt5"|g' src/gui/util_gui.cpp

%build
%cmake \
	-DCMAKE_DISABLE_FIND_PACKAGE_ClangTidy:BOOL=TRUE \
	-DCMAKE_DISABLE_FIND_PACKAGE_IWYU:BOOL=TRUE
%cmake_build

%install
%cmake_install
%find_lang %name --with-qt

%check
cmake --build %_cmake__builddir/test -j%__nprocs

%files -f %name.lang
%doc COPYING INSTALL.md README.md
%doc %_docdir/%name/
%_bindir/*
%_man1dir/*
%_datadir/%name/
%_desktopdir/*
%_datadir/mime/packages/*
%_iconsdir/hicolor/*/mimetypes/*
%_iconsdir/hicolor/*/apps/*

%changelog
