Name: openssl-gost-engine
Version: 3.0.2
Release: alt5

License: Apache-2.0
Summary: A reference implementation of the Russian GOST crypto algorithms for OpenSSL

Group: System/Libraries

URL: https://github.com/gost-engine/engine.git

Source: %name-%version.tar
Source1: openssl-gost.control
Source2: openssl-gost-control-check.sh
Source3: libprov.tar

Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
# due to gost algorithms identifiers (in headers)
BuildRequires: libssl-devel >= 3.0.0
# to test the control script
BuildRequires: control libcrypto >= 3.0.0

%{?!_without_check:%{?!_disable_check:BuildRequires: ctest perl-devel perl-Test2-Suite openssl}}

# due to gost algorithms identifiers (inside libcrypto)
Requires: libcrypto >= 1.1.0j-alt2

%description
A reference implementation of the Russian GOST crypto algorithms for OpenSSL.

%package -n gostsum
Summary: GOST file digesting utilites
Group: File tools

%description -n gostsum
GOST file digesting utilites.

%prep
%setup -a3
%patch -p1

%build
%ifarch %e2k
# lcc 1.23.12: test_curves.c: if ((test = (e)))
%add_optflags -Wno-error=assign-where-compare-meant
%endif
%cmake \
	#

%cmake_build

%install
%cmake_install

# Install the control scripts
install -D -p -m0755 %_sourcedir/openssl-gost.control \
        %buildroot%_controldir/openssl-gost

# Delete unused *.cmake scripts (TODO: a devel package?):
rm -rfv %buildroot%_datadir/cmake

%check
CTEST_OUTPUT_ON_FAILURE=1 \
	%cmake_build -t test

%_sourcedir/openssl-gost-control-check.sh %_sourcedir/openssl-gost.control

%files
%_libdir/openssl/engines-3/gost.so
%_libdir/ossl-modules/gostprov.so
%_libdir/libgost.so
%_libdir/libgostprov.so
%_controldir/openssl-gost

%files -n gostsum
%_bindir/gost*sum*
%_man1dir/gost*sum*

%changelog
