%add_python3_lib_path %_datadir/openuds
%allow_python3_import_path %_datadir/openuds
%add_findreq_skiplist %_datadir/openuds/uds/transports/*/scripts/windows/* %_datadir/openuds/uds/transports/*/scripts/macosx/*
%add_python3_req_skip uds.forward
%add_python3_req_skip uds.tunnel
%filter_from_provides /^python3(manage)/d
%filter_from_provides /^python3(server)/d
%filter_from_provides /^python3(server\.settings)/d
%filter_from_provides /^python3(server\.urls)/d
%filter_from_provides /^python3(server\.wsgi)/d

Name: openuds-server
Version: 3.6.0
Release: alt10
Summary: Universal Desktop Services (UDS) Broker
License: BSD-3-Clause and MIT and Apache-2.0
Group: Networking/Remote access
URL: https://github.com/dkmstr/openuds
AutoReqProv: yes, nopython
Source0: %name-%version.tar

Source2: openuds_tunnel_register.py
Source10: openuds-httpd.conf
Source11: openuds-httpd-ssl.conf
Source12: openuds.logrotate
Source13: openuds-nginx-sites.conf
Source15: openuds-taskmanager.service
Source16: openuds-web.service
Source17: openuds-tmpfile.conf

BuildRequires(pre): rpm-macros-systemd
Requires: python3-module-django >= 2.2
Requires: python3-module-django-dbbackend-mysql >= 2.2
Requires: python3-module-django-dbbackend-sqlite3 >= 2.2
Requires: openssl
Requires: logrotate
Requires: openuds-installers

Conflicts: openuds-tunnel openuds-guacamole-tunnel
BuildArch: noarch
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): webserver-common rpm-build-webserver-common rpm-macros-apache2
BuildRequires: python3-module-django

%description
OpenUDS (Universal Desktop Services) is a multiplatform connection broker for:
- VDI: Windows and Linux virtual desktops administration and deployment
- App virtualization
- Desktop services consolidation

This package provides the required components
to allow this machine to work as UDS Broker.


%package apache2
Group: Networking/WWW
BuildArch: noarch
Summary: apache2 configs for %name
Requires: %name = %version-%release
Requires: apache2-httpd-prefork-like
Requires: apache2-base
Requires: apache2-mod_wsgi-py3

%description apache2
%summary

%package nginx
Group: Networking/WWW
BuildArch: noarch
Summary: nginx configs for %name
Requires: %name = %version-%release
Requires: nginx
Requires: python3-module-gunicorn
Requires: cert-sh-functions

%description nginx
%summary

%prep
%setup

sed -i 's|#!/usr/bin/env python3|#!/usr/bin/python3|' \
    $(find . -name '*.py')

%build
# Compile localization files
django-admin compilemessages
#find src/uds/locale -name \*.po -delete

%install

mkdir -p %buildroot{%_datadir,%_logdir,%_sysconfdir,%_sharedstatedir}/openuds
cp -r src/* %buildroot%_datadir/openuds/
mkdir -p %buildroot%_datadir/openuds/uds/static/clients
mkdir -p %buildroot%_datadir/openuds/uds/osmanagers/WindowsOsManager/files
mv %buildroot%_datadir/openuds/server/settings.py.sample %buildroot%_sysconfdir/openuds/settings.py
ln -r -s %buildroot%_logdir/openuds %buildroot%_datadir/openuds/log
ln -r -s %buildroot%_sysconfdir/openuds/settings.py %buildroot%_datadir/openuds/server/settings.py
# Script for register openuds tunnel
install -p -D -m 755 %SOURCE2 %buildroot%_bindir/openuds_tunnel_register.py
# drop httpd-conf snippet
install -p -D -m 644 %SOURCE10 %buildroot%apache2_sites_available/openuds.conf
install -p -D -m 644 %SOURCE11 %buildroot%apache2_sites_available/openuds-ssl.conf
mkdir -p %buildroot%apache2_sites_enabled
touch %buildroot%apache2_sites_enabled/openuds.conf
install -p -D -m 644 %SOURCE12 %buildroot%_logrotatedir/openuds-server
install -p -D -m 644 %SOURCE13 %buildroot%_sysconfdir/nginx/sites-available.d/openuds.conf
mkdir -p %buildroot%_sysconfdir/nginx/sites-enabled.d
touch %buildroot%_sysconfdir/nginx/sites-enabled.d/openuds.conf
install -p -D -m 644 %SOURCE15 %buildroot%_unitdir/openuds-taskmanager.service
install -p -D -m 644 %SOURCE16 %buildroot%_unitdir/openuds-web.service
install -p -D -m 644 %SOURCE17 %buildroot%_tmpfilesdir/openuds.conf

%pre
%_sbindir/groupadd -r -f openuds >/dev/null 2>&1 ||:
%_sbindir/useradd -M -r -g openuds -G _webserver -c 'OpenUDS Brocker Daemon' \
        -s /bin/false  -d %_sharedstatedir/openuds openuds >/dev/null 2>&1 ||:

%post
if [ $1 -eq 1 ]; then
# ugly hack to set a unique SECRET_KEY
	sed -i "/^SECRET_KEY.*$/{N;s/^.*$/SECRET_KEY='`openssl rand -hex 10`'/}" %_sysconfdir/openuds/settings.py
fi

%post_systemd_postponed openuds-taskmanager.service

%preun
%preun_systemd openuds-taskmanager.service

%post nginx
%post_systemd_postponed openuds-web.service
# Create SSL certificate for HTTPS server
cert-sh generate nginx-openuds ||:

%preun nginx
%preun_systemd openuds-web.service

%files
%_datadir/openuds
%dir %attr(0750, root, openuds) %_sysconfdir/openuds
%config(noreplace) %attr(0640, root, openuds) %_sysconfdir/openuds/settings.py
%dir %attr(0770, root, openuds) %_sharedstatedir/openuds
%dir %attr(0770, root, openuds) %_logdir/openuds
%config(noreplace) %_logrotatedir/openuds-server
%_unitdir/openuds-taskmanager.service
%_bindir/openuds_tunnel_register.py

%files apache2
%config(noreplace) %apache2_sites_available/*.conf
%ghost %apache2_sites_enabled/*.conf

%files nginx
%config(noreplace) %_sysconfdir/nginx/sites-available.d/openuds.conf
%ghost %_sysconfdir/nginx/sites-enabled.d/openuds.conf
%_unitdir/openuds-web.service
%_tmpfilesdir/openuds.conf

%changelog
