%define osg_version %(pkg-config --modversion openscenegraph)

Name: osgearth
Version: 3.5
Release: alt2

Summary: Dynamic map generation toolkit for OpenSceneGraph
License: LGPL-3.0 with exceptions
Group: Graphics

Url: http://osgearth.org
Source: %name-%version.tar
Source1: submodules.tar
Patch1: osgearth-alt-fix-pathes.patch

BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: git-core
BuildRequires: libGL-devel
BuildRequires: libGLEW-devel
BuildRequires: libGLU-devel
BuildRequires: libOpenSceneGraph-devel
BuildRequires: libXrandr-devel
BuildRequires: libXrender-devel
BuildRequires: libXt-devel
BuildRequires: libcurl-devel
BuildRequires: libexpat-devel
BuildRequires: libgdal-devel
BuildRequires: libgeos-devel
BuildRequires: libprotobuf-devel
BuildRequires: libsqlite3-devel
BuildRequires: libwebp-devel
BuildRequires: libzip-devel
BuildRequires: libzip-utils
BuildRequires: protobuf-compiler
BuildRequires: rapidjson-devel

Provides: osgEarth = %EVR
Obsoletes: osgEarth < %EVR

%description
osgEarth is a scalable terrain rendering toolkit for
OpenSceneGraph. Just create a simple XML file, point it at your
imagery, elevation, and vector data, load it into your favorite OSG
application, and go! osgEarth supports all kinds of data and comes
with lots of examples to help you get up and running quickly and
easily.

%package -n lib%name
Summary: Runtime libraries for osgEarth
Group: System/Libraries
Provides: libosgEarth = %EVR
Obsoletes: libosgEarth < %EVR

%description -n lib%name
osgEarth is a scalable terrain rendering toolkit for
OpenSceneGraph. Just create a simple XML file, point it at your
imagery, elevation, and vector data, load it into your favorite OSG
application, and go! osgEarth supports all kinds of data and comes
with lots of examples to help you get up and running quickly and
easily.

This package contains runtime libraries for osgEarth.

%package -n lib%name-devel
Summary: Development files for osgEarth
Group: Development/C++
Requires: lib%name = %version-%release
Provides: libosgEarth-devel = %EVR
Obsoletes: libosgEarth-devel < %EVR

%description -n lib%name-devel
osgEarth is a scalable terrain rendering toolkit for
OpenSceneGraph. Just create a simple XML file, point it at your
imagery, elevation, and vector data, load it into your favorite OSG
application, and go! osgEarth supports all kinds of data and comes
with lots of examples to help you get up and running quickly and
easily.

This package contains development files for osgEarth.

%package examples
Summary: Sample applications for osgEarth
Group: Development/Documentation
Requires: %name-data
Provides: osgEarth-examples = %EVR
Obsoletes: osgEarth-examples < %EVR

%description examples
osgEarth is a scalable terrain rendering toolkit for
OpenSceneGraph. Just create a simple XML file, point it at your
imagery, elevation, and vector data, load it into your favorite OSG
application, and go! osgEarth supports all kinds of data and comes
with lots of examples to help you get up and running quickly and
easily.

This package contains sample applications for osgEarth.

%package data
Summary: Sample data files for osgEarth
Group: Development/Documentation
BuildArch: noarch
Provides: osgEarth-data = %EVR
Obsoletes: osgEarth-data < %EVR

%description data
osgEarth is a scalable terrain rendering toolkit for
OpenSceneGraph. Just create a simple XML file, point it at your
imagery, elevation, and vector data, load it into your favorite OSG
application, and go! osgEarth supports all kinds of data and comes
with lots of examples to help you get up and running quickly and
easily.

This package contains sample data files for osgEarth.

%prep
%setup
tar xf %SOURCE1
%patch1 -p1
%ifarch %e2k
# error: undefined reference to symbol '_ZTIN9osgViewer14GraphicsWindowE'
sed -i 's/OSGUTIL_LIBRARY/& OSGVIEWER_LIBRARY/' \
	src/applications/osgearth_bakefeaturetiles/CMakeLists.txt
%endif
# Remove non-free content
rm -rf data/loopix
 
# Disable fastdxt driver on non x86 arches, requires x86 intrinsics
%ifnarch x86_64
sed -i 's|add_subdirectory(fastdxt)|# add_subdirectory(fastdxt)|' src/osgEarthDrivers/CMakeLists.txt
%endif

%build
%ifarch %e2k
%add_optflags -std=c++14
# OpenSceneGraph debuginfo too large now => unmets
%global __find_debuginfo_files %nil
%endif
%cmake \
       -Wno-dev \
       -DCMAKE_BUILD_TYPE="Release"
%cmake_build

%install
%cmakeinstall_std
# Supposed to take data files
mkdir -p %buildroot%_datadir/osgEarth
cp -a data tests %buildroot%_datadir/osgEarth

%files -n lib%name
%doc README.md
%_libdir/libosgEarth*.so.*
%_libdir/osgPlugins-*/osgdb_*.so

%files -n lib%name-devel
%_includedir/osg*
%_libdir/libosg*.so
%_datadir/cmake/osgEarthConfig*.cmake

%files examples
%_bindir/*

%files data
%_datadir/osgEarth

%changelog
