%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_without libpam
%def_with    libpam0
%def_without libpam2

%define pamconfdir   %_sysconfdir/pam.d
%define pamlibdir    /%_lib/security

%ifdef add_findprov_lib_path
%add_findprov_lib_path %pamlibdir
%endif

Name: pam_alreadyloggedin
Version: 0.3.2
Release: alt5
Summary: Skip password authorization if user is already logged in
Summary(ru_RU.UTF-8): Вход в систему без пароля, если уже выполнен вход с другой консоли
License: BSD-3-Clause
Group: System/Base
Url: http://ilya-evseev.narod.ru/posix/%name

Source: %name-%version.tar

%if_with libpam
BuildRequires: libpam-devel
%endif
%if_with libpam0
BuildRequires: libpam0-devel
%endif
%if_with libpam2
BuildRequires: libpam2-devel
%endif

%description
Based on the appropriate module from FreeBSD project source tree,
%name is a PAM module which allows you to skip
authorization stuff (like password entering, etc.),
if you are already logged in on the another console.
See using example in %_defaultdocdir/%name-%version/examples directory.

%description -l ru_RU.UTF-8
%name является модулем PAM, который позволяет пользователю
пропускать ввод пароля при входе в систему,
если этот пользователь уже зашёл в систему с другой консоли.

Данный модуль не начинает использоваться немедленно при инсталляции;
пример политики PAM для его подключения смотрите в каталоге
%_defaultdocdir/%name-%version/examples.

%prep
%setup

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%make_build

%install
%make_install install FAKEROOT=%buildroot MAN8DIR=%_man8dir SECUREDIR=/%_lib/security

mkdir examples
install -pD -m644 login.sso examples/login
sed -i -e 's:/lib/security/::g' examples/login

rm -f %buildroot%pamconfdir/login.sso

%files
%doc examples
%pamlibdir/%name.so
%_man8dir/%name.8*

%changelog
