

# Use our own configure in order to prevent --target, which makes autotools believe we are cross compiling
%global pccconfigure \
 export CFLAGS="${FLAGS}"; \
 export CXXFLAGS="${FLAGS}"; \
 export FFLAGS="${FLAGS}"; \
 ./configure --program-prefix= --prefix=%prefix --exec-prefix=%prefix --bindir=%_bindir --sbindir=%_sbindir --sysconfdir=%_sysconfdir --datadir=%_datadir --includedir=%_includedir --libdir=%_libdir --libexecdir=%_libexecdir --localstatedir=%_localstatedir --sharedstatedir=%_sharedstatedir --mandir=%_mandir --infodir=%_infodir

# Use pcc to build? (This option is for sanity testing the compiler)
%global usepcc 0
# RPM does not play well with pcc compiled package
%if %usepcc
%define debug_package %nil
%endif

# Release tag
%global rel 1

Name: pcc
Version: 1.2.0
%if %usepcc
Release: alt2
%else
Release: alt2
%endif
Summary: The Portable C Compiler
Group: Development/C
License: BSD with advertising and BSD and ISC
Url: http://pcc.ludd.ltu.se/
Packager: Ilya Mashkin <oddity@altlinux.ru>
Source0: pcc-%version.tar
Source1: pcc-libs-%version.tar
# Patch to disable the use of -g in pcc-libs/csu/linux/ which is partly assembler code.
# Also, inlineing is disabled because it will break the code.
# Also, remove default -O flag from the code.
Patch0: pcc-20141210-flags.patch

# Currently only x86 and x86_64 supported both in ppc and ppc-libs

BuildRequires: bison flex
Requires: glibc-devel

%if %usepcc
BuildRequires: pcc
%endif

ExclusiveArch: x86_64 %ix86

%description
The compiler is based on the original Portable C Compiler by Stephen C.
Johnson, written in the late 70's. Even though much of the compiler has been
rewritten, some of the basics still remain.
PCC debuted in Unix Version 7 and replaced the DMR compiler (Dennis Ritchie's
original C compiler) in both System V and the BSD 4.x releases. Some history
about pcc is in the A History of UNIX before Berkeley: UNIX Evolution:
1975-1984 and in the Evolution of C.

About 50%% of the frontend code and 80%% of the backend code has been rewritten.
Most stuff is written by Anders Magnusson, with the exception of the data-flow
analysis part and the SSA conversion code which is written by Peter A Jonsson,
and the Mips port that were written as part of a project by undergraduate
students at Lulea University of Technology (LTU).

Caution: the compiler is still undergoing heavy development.

%prep
%setup -q -a1
# Rename the libs directory for the patch to work
mv pcc-libs-%version pcc-libs
# Apply patch
%patch0 -p1

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
# Set architecture directory needed for include flag
%ifarch x86_64
export archdir=amd64
%endif
%ifarch %ix86
export archdir=i386
%endif

# Use pcc to build?
%if %usepcc
export FLAGS="-g"
export CC="pcc"
export CPP="pcc -E"
%else
export FLAGS="%optflags"
export CC="gcc"
export CPP="gcc -E"
%endif

# Flags for files that can't be built as debug
export CFLAGS_NODEBUG=$(echo ${FLAGS} | sed -e 's/\(^\| \)-g\($\| \)/ /g')

# First, build the library.
cd pcc-libs
%pccconfigure --disable-stripping
make CFLAGS="-I${archdir} -Ilinux -I. ${FLAGS}" CFLAGS_NODEBUG="-I${archdir} -Ilinux -I. $CFLAGS_NODEBUG"
#%{?_smp_mflags}
cd ..
# Then, build the compiler
%pccconfigure --with-assembler=%_bindir/as --with-linker=%_bindir/ld \
 --with-libdir=%_libdir --with-incdir=%_includedir --enable-tls --disable-stripping
make
#%{?_smp_mflags}

%install

# Install the libraries
make -C pcc-libs install DESTDIR=%buildroot strip=no
# Install the compiler
make install DESTDIR=%buildroot strip=no
# Fix man file perms
chmod 644 %buildroot%_mandir/man1/*
# Rename cpp man page
mv  %buildroot%_mandir/man1/{,pcc-}cpp.1
# Directory for pcc-specific include files
mkdir -p %buildroot%_includedir/pcc


%files
%_bindir/pcc
%_bindir/p++
%_bindir/pcpp
%_libdir/pcc/
%_includedir/pcc/
%_libexecdir/cpp
%_libexecdir/ccom
%_libexecdir/cxxcom
%_mandir/man1/ccom.1.*
%_mandir/man1/pcc-cpp.1.*
%_mandir/man1/pcc.1.*
%_mandir/man1/p++.1.*
%_mandir/man1/pcpp.1.*

%changelog
