# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name:    pcmanfm-qt
Version: 2.2.0
Release: alt1
Epoch: 1

Summary: PCManFM-Qt is the Qt port of the LXDE file manager PCManFM
License: GPL-2.0-or-later
Group:   File tools

Url:     https://github.com/lxqt/pcmanfm-qt
Source:  %name-%version.tar
Patch:   %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake
BuildRequires: qt6-base-devel qt6-tools-devel
BuildRequires: plasma6-layer-shell-qt-devel
BuildRequires: libfm-qt6-devel
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: liblxqt-devel
BuildRequires: libmenu-cache-devel
BuildRequires: rpm-build-xdg

Requires: menu-cache

%description
PCManFM-Qt is the Qt port of the LXDE file manager PCManFM.

%prep
%setup
%autopatch -p1

%build
%add_optflags -I%_includedir/KF6/ -L%_libdir/kf6/devel/
%cmake
%cmake_build

%install
%cmake_install

%files
%_bindir/*
%_desktopdir/*.desktop
%_xdgconfigdir/*/*
%_datadir/%name
%_man1dir/*
%_iconsdir/hicolor/scalable/apps/%name.svg
%doc AUTHORS CHANGELOG LICENSE README.md

%changelog
