%define _unpackaged_files_terminate_build 1
#undefine XXX__libtoolize
#define unstable 1
%def_disable static
%def_enable polkit
%def_enable systemd

Name: pcsc-lite
Version: 2.2.2
Release: alt1

Summary: PC/SC Lite smart card framework and applications
License: %bsd
Group: System/Servers

URL: https://pcsclite.apdu.fr/

Source: %name-%version.tar

Source1: pcscd.init
Source2: pcsc-lite-pcscd.sysconfig
Source3: pcsc-lite.tmpfiles
Patch0: pcsc-lite-alt-use-sysconfig-dir.patch

Requires: libpcsclite = %version-%release
%{?_enable_polkit:Requires: polkit}

BuildRequires(pre): rpm-build-python3
BuildRequires: rpm-build-licenses perl-podlators
BuildRequires: flex
BuildRequires: pkgconfig(libudev)
BuildRequires: autoconf-archive

%{?_enable_polkit:BuildRequires: pkgconfig(polkit-gobject-1) >= 0.111}
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}

%if_enabled static
BuildRequires: glibc-devel-static
%endif

%description
pcscd is the daemon program for PC/SC Lite. It is a resource
manager that coorinates communications with Smart Card readers and Smart
Cards that are connected to the system.
The purpose of PCSC Lite is to provide a Windows(R) SCard interface
in a very small form factor for communicating to smartcards and readers.
PCSC Lite uses the same winscard api as used under Windows(R)

This package contains the service for PC/SC Lite.

%package -n libpcsclite
Group: System/Libraries
Summary: Libraries for pcscd
#
%description -n libpcsclite
Libraries for pcscd. pcscd is the daemon program
for PC/SC Lite. It is a resource manager that coorinates
communications with Smart Card readers and Smart Cards
that are connected to the system. The purpose of PCSC Lite
is to provide a Windows(R) SCard interface in a very small
form factor for communicating to smartcards and readers.
PCSC Lite uses the same winscard api as used under Windows(R)

%package -n libpcsclite-devel
Group: Development/C
Summary: Haeders and other development files for libpcsclite
Requires: libpcsclite = %EVR
#
%description -n libpcsclite-devel
Haeders and other development files for libpcsclite

%package -n libpcsclite-devel-static
Group: Development/C
Summary: Static libraries for libpcsclite
Requires: libpcsclite-devel = %EVR
#
%description -n libpcsclite-devel-static
Static libraries for libpcsclite

%prep
%setup
%patch0 -p1
subst 's|AC_PREREQ(\[2.69\])|AC_PREREQ(\[2.68\])|' configure.ac
subst 's|/usr/bin/python$|%__python3|' src/spy/pcsc-spy

%build
%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_enable polkit} \
    --enable-debugatr \
    --enable-ipcdir=/var/run/pcscd \
    --enable-usbdropdir=%_libdir/pcsc/drivers \
    --with-systemdsystemunitdir=%_unitdir

%make_build

# pdf
%make_build -C doc

%install
%makeinstall_std

install -pDm755 %SOURCE1 %buildroot/%_initdir/pcscd
install -pDm644 %SOURCE2 %buildroot/%_sysconfdir/sysconfig/pcscd

mkdir -p %buildroot%_sysconfdir/reader.conf.d
mkdir -p %buildroot/var/run/pcscd
mkdir -p %buildroot%_libdir/pcsc/drivers

# enable pcscd socket activation
mkdir -p %buildroot%_unitdir/sockets.target.wants
ln -s ../pcscd.socket %buildroot%_unitdir/sockets.target.wants
mkdir -p %buildroot/lib/tmpfiles.d
install -pDm644 %SOURCE3 %buildroot/lib/tmpfiles.d/pcsc-lite.conf

# remove default installed docs
rm -rf %buildroot/%_defaultdocdir/pcsc-lite

%preun
%preun_service pcscd

%post
%post_service pcscd

%files
%doc AUTHORS COPYING HELP NEWS README* SECURITY doc/README.polkit
%dir %_sysconfdir/reader.conf.d
%config(noreplace) %_sysconfdir/sysconfig/pcscd
%_initdir/pcscd
%if_enabled systemd
%_unitdir/pcscd.*
%_unitdir/sockets.target.wants/*
%endif
/lib/tmpfiles.d/pcsc-lite.conf
%_sbindir/pcscd
#_bindir/make_hash_link.sh
%_man5dir/*
%_man8dir/*
%dir %_libdir/pcsc
%dir %_libdir/pcsc/drivers
%{?_enable_polkit:%_datadir/polkit-1/actions/*.policy}
%ghost %dir /var/run/pcscd

# NB: .so belongs here, see ALT#25275
%files -n libpcsclite
%_libdir/libpcsclite.so.*
%_libdir/libpcsclite.so
%_libdir/libpcsclite_real.so.*
%_libdir/libpcsclite_real.so

%files -n libpcsclite-devel
%doc ChangeLog
%_bindir/pcsc-spy
%_libdir/libpcscspy.so*
%_includedir/PCSC/
%_libdir/pkgconfig/libpcsclite.pc
%_man1dir/pcsc-spy.*

%if_enabled static
%files -n libpcsclite-devel-static
%_libdir/libpcsclite.a
%endif

%changelog
