%define _unpackaged_files_terminate_build 1
%def_with bootstrap

%define dist AnyEvent
Name: perl-%dist
Version: 7.17
Release: alt3

Summary: Framework for multiple event loops
License: GPL or Artistic
Group: Development/Perl

URL: %CPAN %dist
Source0: http://www.cpan.org/authors/id/M/ML/MLEHMANN/%{dist}-%{version}.tar.gz
Patch: AnyEvent-7.17-syntax-fix.patch

BuildArch: noarch

# classified as non-text
Provides: perl(AnyEvent/Util/uts46data.pl)

# missing
%add_findreq_skiplist */AnyEvent/Impl/Cocoa.pm
%add_findreq_skiplist */AnyEvent/Impl/FLTK.pm
%add_findreq_skiplist */AnyEvent/Impl/Qt.pm
# in autoimports
%add_findreq_skiplist */AnyEvent/Impl/UV.pm
# should be ryun inside Irssi
%add_findreq_skiplist */AnyEvent/Impl/Irssi.pm
%if_with bootstrap
# XXX choose default model?
%add_findreq_skiplist */AnyEvent/Impl/*.pm
%else
BuildRequires: perl(Event.pm) perl(Event/Lib.pm) perl(Glib.pm) perl(IO/Async/Loop.pm) perl(Irssi.pm) perl(POE.pm) perl(Tk.pm)
# in autoimports 
#BuildRequires: perl(UV.pm)
%endif

# Automatically added by buildreq on Wed Oct 26 2011 (-bi)
BuildRequires: perl-Async-Interrupt perl-EV perl-Guard perl-Net-SSLeay perl-Unicode-Normalize perl-devel perl(IO/AIO.pm) perl(AnyEvent/AIO.pm)

%description
AnyEvent provides an identical interface to multiple event loops. This allows
module authors to utilise an event loop without forcing module users to use the
same event loop (as only a single event loop can coexist peacefully at any one
time).

%prep
%setup -q -n %{dist}-%{version}
%patch -p1
sed -i 's@require "lib/AnyEvent@require "AnyEvent@' lib/AnyEvent/Util.pm

# disable archlib hack
sed -i- '/ PM /,/}/d' Makefile.PL

%build
%if_without bootstrap
export PERL_ANYEVENT_LOOP_TESTS=1
%endif
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/AE.pm
%perl_vendor_privlib/AnyEvent*

%changelog
