Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Child
Version:        0.013
Release:        alt3_18
Summary:        Object oriented simple interface to fork()
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Child
Source0:        https://cpan.metacpan.org/authors/id/E/EX/EXODIST/Child-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests only
BuildRequires:  perl(Capture/Tiny.pm)
BuildRequires:  perl(Test/More.pm)
# Dependencies
Requires:       perl(Exporter.pm) >= 5.570
Requires:       perl(POSIX.pm)

# Filter under-specified dependency

Source44: import.info
%filter_from_requires /^perl(Exporter.pm)/d

%description
Fork is too low level and difficult to manage. Often people forget to exit
at the end, reap their children, and check exit status. The problem is the
low level functions provided to do these things. Throw in pipes for IPC and
you just have a pile of things nobody wants to think about.

%prep
%setup -q -n Child-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
make test

%files
%if 0%{?_licensedir:1}
%doc --no-dereference LICENSE
%else
%doc LICENSE
%endif
%doc Changes README
%{perl_vendor_privlib}/Child.pm
%{perl_vendor_privlib}/Child/

%changelog
