Name:      perl-File-CheckTree
Version:   4.42
Release:   alt3
Summary:   Run many file-test checks on a tree
License:   Perl
Group: 	   Development/Perl
URL:       https://metacpan.org/release/File-CheckTree
Source0:   https://cpan.metacpan.org/authors/id/R/RJ/RJBS/File-CheckTree-%{version}.tar.gz
BuildArch: noarch
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
BuildRequires: perl-devel
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
# Run-time:
BuildRequires: perl(Cwd.pm)
BuildRequires: perl(deprecate.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(if.pm)
# Tests:
BuildRequires: perl(overload.pm)
BuildRequires: perl(Test/More.pm)
Requires: perl(deprecate.pm)
Source44: import.info

%description
File::CheckTree::validate() routine takes a single multi-line string
consisting of directives, each containing a file name plus a file test to try
on it. (The file test may also be a "cd", causing subsequent relative file
names to be interpreted relative to that directory.) After the file test you
may put || die to make it a fatal error if the file test fails. The default is
|| warn.  The file test may optionally have a "!' prepended to test for the
opposite condition. If you do a cd and then list some relative file names, you
may want to indent them slightly for readability. If you supply your own die()
or warn() message, you can use $file to interpolate the file name.

%prep
%setup -q -n File-CheckTree-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
unset RELEASE_TESTING
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
