%define module  HTML-StripScripts
Name: perl-%module

Group: Development/Perl
BuildRequires(pre): perl-devel rpm-build-licenses
BuildRequires: perl-podlators
Version:        1.06
Release:        alt3
Summary:        Strip scripting constructs out of HTML
License:        %perl_license
URL:            https://metacpan.org/release/HTML-StripScripts
Source0:        https://cpan.metacpan.org/authors/id/D/DR/DRTECH/HTML-StripScripts-%{version}.tar
BuildArch:      noarch
BuildRequires:  perl(base.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)

%description
This module strips scripting constructs out of HTML, leaving as much non-
scripting markup in place as possible. This allows web applications to
display HTML originating from an untrusted source without introducing XSS
(cross site scripting) vulnerabilities.

%prep
%setup -q -n %module-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%check
make test

%files
%doc README Changes
%perl_vendor_privlib/HTML/*.pm

%changelog
