%define _unpackaged_files_terminate_build 1
# we use custom %%check
%define _without_test 1
%define dist Term-ReadLine-Gnu
Name: perl-%dist
Version: 1.46
Release: alt1

Summary: Perl interface to the GNU Readline library
License: GPLv2+ or Artistic-2.0
Group: Development/Perl

URL: %CPAN %dist
Source0: %dist-%version.tar
Source1: Term-ReadLine.tar
Source2: Makefile.PL

Patch1: perl-Term-ReadLine-Gnu-1.46-at-Gnu.pm-use-XSLoader.patch
# two merged in one Patch3 file
# hist/perl-Term-ReadLine-Gnu-at-Gnu.xs-use-curses.patch
# hist/perl-Term-ReadLine-Gnu-at-dont-use-xmalloc.patch
Patch3: perl-Term-ReadLine-Gnu-1.46-at-xmalloc-at-curses.patch
Patch6: perl-Term-ReadLine-Gnu-1.46-at-Gnu_XS.pm-pass-syntax-check.patch
Patch7: perl-Term-ReadLine-Gnu-1.46-at-Gnu_XS.pm-debian-10term.patch
Patch8: perl-Term-ReadLine-Gnu-at-add-Term-Readline-to-MANIFEST.patch
Patch9: perl-Term-ReadLine-Gnu-1.46-at-perlsh-dont-import-POSIX.patch
Patch10: perl-Term-ReadLine-Gnu-1.46-at-disable-Tk-test.patch
Patch11: Term-ReadLine-1.15-at.patch


# Automatically added by buildreq on Fri Oct 07 2011
BuildRequires: libncurses-devel libreadline-devel perl-devel perl-Encode
BuildRequires: expect

%description
Term::ReadLine::Gnu is an implementation of the interface to the GNU
Readline library.  This module gives you input line editing facility,
input history management facility, word completion facility, etc.

%prep
%setup -q -n %dist-%version -a1
mv Makefile.PL Makefile.PL.orig
cp -f %{SOURCE2} Makefile.PL

%patch1 -p1
%patch3 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p0

%build
%perl_vendor_build
#PERL_RL_TEST_TK=1 perl -Mblib t/callback.t

%install
%perl_vendor_install

%check
# Expect is used so that we get a PTY, as if we were
# in a real terminal, where readline works
expect -c '
        spawn make test
        expect eof
        exit [lindex [wait] 3]
'

%files
%doc eg Changes INSTALL.md README.md
%perl_vendor_archlib/Term
%perl_vendor_autolib/Term

%changelog
