%define _unpackaged_files_terminate_build 1
%define dist libwww-perl
Name: perl-libwww
Version: 6.77
Release: alt1

Summary: WWW client/server library for Perl (aka LWP)
License: GPL or Artistic
Group: Development/Perl

URL: %CPAN %dist
Source0: http://www.cpan.org/authors/id/O/OA/OALDERS/%{dist}-%{version}.tar.gz

BuildArch: noarch

Provides: %name-perl = %version
Obsoletes: %name-perl < %version

# requires Authen::NTLM; not required by any package
%add_findreq_skiplist */LWP/Authen/Ntlm.pm
# requires HTTP::GHTTP; not required by any package
%add_findreq_skiplist */LWP/Protocol/GHTTP.pm

# disable HTML::Format dependencies in lwp-request
%filter_from_requires /^perl.HTML.Format/d

# Automatically added by buildreq on Thu Jan 31 2013
# optimized out: perl-Encode perl-HTTP-Date perl-HTTP-Message perl-LWP-MediaTypes perl-Pod-Escapes perl-Pod-Simple perl-URI perl-libnet perl-podlators
BuildRequires: perl-Encode-Locale perl-File-Listing perl-HTML-Parser perl-HTTP-Daemon perl-HTTP-Negotiate perl-Net-HTTP perl-WWW-RobotRules perl-devel perl-podlators perl(Test/Fatal.pm) perl(Try/Tiny.pm) perl(Test/RequiresInternet.pm) perl(Data/Dump.pm) perl(Module/Metadata.pm) perl(CPAN/Meta/Requirements.pm) perl(HTTP/CookieJar/LWP.pm) perl(Test/Needs.pm) perl(Module/Load.pm) perl(HTTP/Cookies.pm)

%description
The libwww-perl collection is a set of Perl modules which provides a
simple and consistent application programming interface to the
World-Wide Web.  The main focus of the library is to provide classes
and functions that allow you to write WWW clients.  The library also
contain modules that are of more general use and even classes that
help you implement simple HTTP servers.

%prep
%setup -q -n %{dist}-%{version}
bzip2 -k Changes

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

ln -snf lwp-request %buildroot%_bindir/GET
ln -snf lwp-request %buildroot%_bindir/HEAD
ln -snf lwp-request %buildroot%_bindir/POST

ln -snf lwp-request.1 %buildroot%_man1dir/GET.1
ln -snf lwp-request.1 %buildroot%_man1dir/HEAD.1
ln -snf lwp-request.1 %buildroot%_man1dir/POST.1

%files
%doc	README.SSL Changes CONTRIBUTING.md examples
	%_bindir/lwp-*
	%_bindir/GET
	%_bindir/HEAD
	%_bindir/POST
	%_man1dir/lwp-*.*
	%_man1dir/GET.*
	%_man1dir/HEAD.*
	%_man1dir/POST.*
%dir	%perl_vendor_privlib/LWP
	%perl_vendor_privlib/LWP.pm
	%perl_vendor_privlib/LWP/*
%doc	%perl_vendor_privlib/lwp*.pod

%changelog
