%define		php_extension	memcache
Name:	 	php%_php_suffix-%php_extension
Version:	8.2
Release:	alt%php_version.%php_release
Summary:	memcached extension for php%_php_suffix
License:	PHP-3.0
Group:		System/Servers
URL:		https://github.com/websupport-sk/pecl-memcache

BuildRequires(pre): rpm-build-php8.3-version
BuildRequires: php-devel = %php_version zlib-devel
BuildRequires: php%_php_suffix = %php_version memcached /proc

# Source0-url:	https://pecl.php.net/get/memcache-%version.tgz
Source0:	php-%php_extension-%version.tar
Source1:	php-%php_extension.ini
Source2:	php-%php_extension-params.sh
Patch:		php7-memcache-alt-inc.patch

%description 
The php%_php_suffix-%php_extension package contains a dynamic shared object (DSO) for php. The
php%_php_suffix-%php_extension module allows you to work with memcached through handy OO
and procedural interfaces. If you need memcached(1) support for php
applications, you will need to install this package and php.

%prep
%setup -n php-%php_extension-%version
%patch -p2

%build
phpize

export LDFLAGS=-lphp-%_php_version

%configure --enable-memcache --with-zlib-dir=/usr
%php_make

%install
%php_make_install
%__install -D -m 644 %SOURCE1 %buildroot/%php_extconf/%php_extension/config
%__install -D -m 644 %SOURCE2 %buildroot/%php_extconf/%php_extension/params

%ifnarch %ix86
%check
# remove localhost via unix domain socket tests
rm -f tests/035.phpt
rm -f tests/053.phpt
# remove online test
rm -f tests/056.phpt
# run memcached for tests
memcached -d -s /tmp/memcached.sock
memcached -d -p 11212
memcached -d
NO_INTERACTION=1 make test
%endif

%files
%php_extconf/%php_extension
%php_extdir/*
%doc CREDITS README

%post
%php_extension_postin

%preun
%php_extension_preun

%changelog
