%def_disable libcap
%def_enable qt5
%def_enable qt6
%def_disable fltk

Name: pinentry
Version: 1.3.1
Release: alt2

Summary: Simple PIN or passphrase entry dialog
License: GPLv2+
Group: File tools
Url: http://gnupg.org/related_software/pinentry/

Requires: %name-common
Requires: %name-qt5

# ftp://ftp.gnupg.org/gcrypt/pinentry/%name-%version.tar.gz
Source: %name-%version.tar
Source1: pinentry-wrapper
# FC
Patch1: pinentry-1.1.1-coverity.patch

%if_enabled qt5
BuildRequires: qt5-base-devel kf5-kwayland-devel rpm-build-kf5
%endif
%if_enabled libfltk-devel
BuildRequires: libfltk-devel
%endif
%if_enabled qt6
BuildRequires: qt6-base-devel kf6-kwindowsystem-devel kf6-kguiaddons-devel rpm-build-kf6
%endif
%if_enabled libcap
BuildRequires: libcap-devel
%endif
BuildRequires: gcc-c++ libgtk+2-devel libncursesw-devel
BuildRequires: libsecret-devel gcr-libs-devel libassuan-devel
BuildRequires: texinfo

%description
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.

%package common
Group: %group
Summary: %summary
Provides: %name = %version-%release
Provides: %name-terminal = %version-%release
Provides: %name-console = %version-%release
Provides: %name-tty = %EVR
Provides: %name-curses = %EVR
Obsoletes: %name-curses < %EVR
Conflicts: pinentry < 0.7.2 pinentry-curses < 0.7.2
Conflicts: pinentry-qt < 0.7.2 pinentry-gtk < 0.7.2

%package gtk2
Group: %group
Summary: %summary
Requires: %name-common = %EVR
Requires: xprop
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release
Provides: pinentry-gtk = %EVR
Obsoletes: pinentry-gtk < %EVR

%package gnome3
Group: %group
Summary: %summary
Requires: %name-common = %EVR
Requires: xprop
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release

%package qt5
Group: %group
Summary: %summary
Requires: xprop
Requires: %name-common = %EVR
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release

%package qt6
Group: %group
Summary: %summary
Requires: xprop
Requires: %name-common = %EVR
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release
Provides: pinentry-qt = %EVR
Obsoletes: pinentry-qt < %EVR

%description gtk2
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.
%description gnome3
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.
%description qt5
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.
%description qt6
This is simple PIN or passphrase entry dialog which utilize
the Assuan protocol as described by the aegypten project.
%description common
This package contains common files and documentation for %name.

%prep
%setup -T -c
tar xf %SOURCE0
mv %name-%version gui
pushd gui
%patch1 -p1
popd

%{?_enable_qt6:cp -a gui gui-qt6}
%{?_enable_qt5:cp -a gui gui-qt5}
cp -a gui tui

install -pm644 %SOURCE1 pinentry-wrapper

for d in tui gui \
             %{?_enable_qt6:gui-qt6} \
             %{?_enable_qt5:gui-qt5} ; do
    pushd $d
    %autoreconf
    popd
done

%build
%add_optflags -std=gnu++17

pushd tui
%configure \
    --disable-rpath \
    --enable-pinentry-curses \
    --enable-pinentry-tty \
    --disable-pinentry-gtk2 \
    --disable-pinentry-fltk \
    --disable-pinentry-gnome3 \
    --disable-pinentry-qt \
    --disable-pinentry-qt5 \
    --disable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd

pushd gui
%configure \
    --disable-rpath \
    --disable-pinentry-curses \
    --disable-pinentry-tty \
    --enable-pinentry-gtk2 \
    %{?_enable_fltk:--enable-pinentry-fltk} \
    --enable-pinentry-gnome3 \
    --disable-pinentry-qt \
    --disable-pinentry-qt5 \
    --disable-pinentry-qt-clipboard \
    --enable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd

%if_enabled qt6
pushd gui-qt6
export KF6GUIADDONS_LIBS='-lKF6GuiAddons -lQt6Gui -lQt6Core -L%_K6link'
%configure \
    --disable-rpath \
    --disable-pinentry-curses \
    --disable-pinentry-tty \
    --disable-pinentry-gtk2 \
    --disable-pinentry-fltk \
    --disable-pinentry-gnome3 \
    --enable-pinentry-qt \
    --disable-pinentry-qt5 \
    --enable-pinentry-qt-clipboard \
    --enable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd
%endif

%if_enabled qt5
pushd gui-qt5
export KF5WAYLANDCLIENT_LIBS="`pkg-config  --libs KF5WaylandClient` -L%_K5link"
%configure \
    --disable-rpath \
    --disable-pinentry-curses \
    --disable-pinentry-tty \
    --disable-pinentry-gtk2 \
    --disable-pinentry-fltk \
    --disable-pinentry-gnome3 \
    --disable-pinentry-qt \
    --enable-pinentry-qt5 \
    --enable-pinentry-qt-clipboard \
    --enable-libsecret \
    %{?_enable_libcap:--with-libcap}%{!?_enable_libcap:--without-libcap} \
    #
%make_build
popd
%endif

%install
pushd tui
%makeinstall_std
popd
rm %buildroot%_bindir/%name

pushd gui
%makeinstall_std
popd
rm %buildroot%_bindir/%name

%if_enabled qt6
pushd gui-qt6
%makeinstall_std
popd
[ -e %buildroot/%_bindir/%name-qt ] && \
    mv %buildroot/%_bindir/%name-qt %buildroot/%_bindir/%name-qt6 ||:
if [ -e %buildroot/%_desktopdir/org.gnupg.pinentry-qt.desktop ]; then
    mv %buildroot/%_desktopdir/org.gnupg.pinentry-qt{,6}.desktop
    sed -i '/^Exec=/s|pinentry-qt$|pinentry-qt6|' %buildroot/%_desktopdir/org.gnupg.pinentry-qt6.desktop
fi
%endif

%if_enabled qt5
pushd gui-qt5
%makeinstall_std
popd
[ -e %buildroot/%_bindir/%name-qt ] && \
    mv %buildroot/%_bindir/%name-qt %buildroot/%_bindir/%name-qt5 ||:
%endif

ln -s %name-gtk-2 %buildroot/%_bindir/%name-gtk

install -pDm755 pinentry-wrapper %buildroot/%_bindir/pinentry

%files gtk2
%_bindir/%name-gtk
%_bindir/%name-gtk-2

%if_enabled qt6
%files qt6
%_bindir/%name-qt6
%_desktopdir/org.gnupg.pinentry-qt6.desktop
%endif

%if_enabled qt5
%files qt5
%_bindir/%name-qt5
%_desktopdir/org.gnupg.pinentry-qt5.desktop
%endif

%files gnome3
%_bindir/%name-gnome3

%files common
%doc gui/AUTHORS gui/NEWS gui/README gui/THANKS
%_bindir/%name
%_bindir/%name-curses
%_bindir/%name-tty
%_datadir/pixmaps/pinentry.png
%_infodir/*.info*

%changelog
