%define major 0.10
%define abiversion 2

Name: podofo
Version: %major.3
Release: alt1

Summary: PDF manipulation library and tools
Summary(ru_RU.UTF8): Библиотека и инструменты для работы с PDF

Packager: Vitaly Lipatov <lav@altlinux.ru>

License: LGPLv2-plus AND GPLv2-plus
Group: Office
URL: https://github.com/podofo/podofo

# Source-url: https://github.com/podofo/podofo/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: fontconfig-devel libfreetype-devel
BuildRequires: libjpeg-devel libpng-devel libtiff-devel
BuildRequires: zlib-devel libxml2-devel libssl-devel

# Just to hide 'Package bzip2 was not found in the pkg-config search path.'
# See https://bugzilla.altlinux.org/30001
BuildRequires: bzlib-devel

%define libname lib%name%abiversion

Requires: %libname = %EVR

%description
PoDoFo is a library and a set of tools to work with the PDF file format.

%description -l ru_RU.UTF8
PoDoFo - это библиотека и набор инструментов для работы с файлами формата PDF.

%package -n %libname
Summary: PoDoFo library
Summary(ru_RU.UTF8): Библиотека PoDoFo
Group: System/Libraries

%description -n %libname
Library to work with PDF files.

%description -n %libname -l ru_RU.UTF8
Библиотека для работы с файлами формата PDF.

%package -n lib%name-devel
Summary: PoDoFo headers
Summary(ru_RU.UTF8): Заголовочные файлы PoDoFo
Group: Development/C
Requires: %libname = %EVR

%description -n lib%name-devel
Development files for the PoDoFo library.

%description -n lib%name-devel -l ru_RU.UTF8
Файлы, необходимые для разработки с использованием библиотеки PoDoFo.

%prep
%setup
subst "s|@PODOFO_VERSION@|%version|" src/podofo/libpodofo.pc.in
# fix broken copying rule
#mkdir test/TokenizerTest/objects

%build
%cmake -DPODOFO_BUILD_TOOLS=ON
%cmake_build

%install
%cmakeinstall_std
mkdir -p %buildroot%_cmakedir/
mv %buildroot%_datadir/%name %buildroot%_cmakedir/

%files
%doc README.md
%_bindir/podofo*

%files -n %libname
%doc README.md AUTHORS.md CHANGELOG.md
%_libdir/libpodofo.so.%abiversion
%_libdir/libpodofo.so.%version

%files -n lib%name-devel
%_includedir/%name/
%_pkgconfigdir/libpodofo.pc
%_cmakedir/%name/
%_libdir/libpodofo.so

%changelog
