%define _unpackaged_files_terminate_build 1
%define u7s_admin_usr u7s-admin
%define u7s_admin_grp u7s-admin
%define kubernetes_grp kube
%define _libexecdir %_prefix/libexec
%define u7s_admin_homedir %_localstatedir/%u7s_admin_usr

Name: podsec
Version: 1.1.6
Release: alt4

Summary: Set of scripts for Podman Security
License: GPLv2+
Group: Development/Other
Url: https://github.com/alt-cloud/podsec
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-systemd
BuildRequires(pre): libsystemd-devel
Requires: podman >= 4.4.2
Requires: shadow-submap >= 4.5
Requires: nginx >= 1.22.1
Requires: docker-registry >= 2.8.1
Requires: pinentry-common
Requires: jq
Requires: yq
Requires: skopeo >= 1.9.1
Requires: wget
Requires: coreutils
Requires: conntrack-tools
Requires: findutils
Requires: iproute2
Requires: iptables
Requires: openssh-server
Requires: curl

%description
This package contains utilities for:
- setting the most secure container application access policies
  (directory /etc/containers/)
- installation of a registry and a web server for access to image signatures
- creating a user with rights to create docker images, signing them and
  placing them in the registry
- creating users with rights to run containers in rootless mode
- downloading docker images from the oci archive, placing them
  on the local system, signing and placing them on the registry
- deploying a rootless kubernetes cluster

%package k8s
Summary: Set of scripts for Kubernetes Security
Group: Development/Other
Requires: podsec >= %EVR
Requires: rootlesskit >= 1.1.0
Requires: slirp4netns >= 1.1.12
Requires: crun >= 1.8.1
Requires: systemd-container
Requires: kubernetes-kubeadm
Requires: kubernetes-crio
Requires: cri-tools
%filter_from_requires /\/usr\/bin\/crio/d
%filter_from_requires /\/usr\/bin\/kubeadm/d
%filter_from_requires /\/usr\/bin\/kubectl/d
%filter_from_requires /\/usr\/bin\/kubelet/d
%filter_from_requires /\/etc\/kubernetes\/kubelet/d

%description k8s
This package contains utilities for:
- deploying a rootless kubernetes cluster
- cluster node configurations

%package k8s-rbac
Summary: Set of scripts for Kubernetes RBAC
Group: Development/Other
Requires: podsec >= %EVR
Requires: openssh-common
Requires: sh

%description k8s-rbac
This package contains utilities for
- creating RBAC users
- generation of certificates and configuration files for users
- generating cluster and usual roles and binding them to users

%package inotify
Summary: Set of scripts for security monitoring
Group: Development/Other
Requires: inotify-tools
Requires: podsec >= %EVR
Requires: openssh-server
Requires: mailx
Requires: trivy
Requires: trivy-server
Requires: psmisc

%description inotify
A set of scripts for  security monitoring by systemd timers
to monitor and identify security threats

%package dev
Summary: Set of scripts for podsec developers
Group: Development/Other
Requires: podsec >= %EVR
Requires: podsec-k8s >= %EVR

%description dev
A set of scripts for developers

%package icinga
Summary: %name-inotify monitoring templates for Icinga 2
Requires: nagwad-icinga-templates >= 0.11.2
Group: Monitoring

%description icinga
Monitoring templates for Icinga 2 defining services to monitor
various Podsec events.

%package nagios
Summary: %name-inotify monitoring templates for Nagios
Requires: nagwad-nagios-templates >= 0.11.2
Group: Monitoring

%description nagios
Monitoring templates for Nagios defining services to monitor
various Podsec events.

%prep
%setup

%build
%make_build

%install
%makeinstall_std unitdir=%_unitdir modulesloaddir=%_modules_loaddir

# JSON templates are packaged using %%doc:
rm -f %buildroot%_datadir/doc/podsec/podsec-icinga2.json

%pre
groupadd -r -f podman >/dev/null 2>&1 ||:
groupadd -r -f podman_dev >/dev/null 2>&1 ||:

%pre k8s
groupadd -r -f %u7s_admin_grp  2>&1 ||:
useradd -r -M -g %u7s_admin_grp -d %u7s_admin_homedir -G %kubernetes_grp,systemd-journal,podman \
    -c 'usernet user account' %u7s_admin_usr  2>&1 ||:
# merge usernetes & podman graphroot
mkdir -p %u7s_admin_homedir/.local/share/usernetes/containers 2>&1 ||:
chown -R %u7s_admin_usr:%u7s_admin_grp %u7s_admin_homedir/.local/share/
cd %u7s_admin_homedir/.local/share
if [ -d containers ]; then mv containers containers.std; fi
ln -sf usernetes/containers . 2>&1 ||:

%post inotify
%post_systemd podsec-inotify-check-containers.service
%post_systemd podsec-inotify-check-kubeapi.service

%preun inotify
%preun_systemd podsec-inotify-check-containers.service
%preun_systemd podsec-inotify-check-kubeapi.service

%post k8s
%post_systemd  u7s.service

%preun k8s
%preun_systemd u7s.service

%files
%_bindir/podsec*
%exclude %_bindir/podsec-save-oci
%exclude %_bindir/podsec-u7s-*
%exclude %_bindir/podsec-k8s-*
%exclude %_bindir/podsec-inotify-*
%_mandir/man?/podsec*
%exclude %_mandir/man?/podsec-k8s-*
%exclude %_mandir/man?/podsec-u7s-*
%exclude %_mandir/man?/podsec-save-oci*
%exclude %_mandir/man?/podsec-inotify-*
%dir %_sysconfdir/podsec
%dir %_libexecdir/podsec
%dir %attr(0755,root,root) %_localstatedir/podsec
%config(noreplace) %_sysconfdir/nagwad/*.sed


%files k8s
%dir %_sysconfdir/podsec/u7s
%config(noreplace) %_sysconfdir/podsec/u7s/*
%_unitdir/user@.service.d/*
%_libexecdir/podsec/u7s
%_localstatedir/podsec/u7s/*
%_modules_loaddir/u7s.conf
%_bindir/podsec-k8s-*
%_bindir/podsec-u7s-*
%exclude %_bindir/podsec-k8s-rbac-*
%exclude %_bindir/podsec-k8s-save-oci
%_mandir/man?/podsec-k8s-*
%exclude %_mandir/man?/podsec-k8s-save-oci*
%_mandir/man?/podsec-u7s-*
%exclude %_mandir/man?/podsec-k8s-rbac-*
%_unitdir/u7s.service
%_userunitdir/*
%u7s_admin_homedir/.??*
%dir %attr(0750,%u7s_admin_usr,%u7s_admin_grp) %u7s_admin_homedir
%dir %attr(0750,%u7s_admin_usr,%u7s_admin_grp) %u7s_admin_homedir/.local
%dir %attr(0750,%u7s_admin_usr,%u7s_admin_grp) %u7s_admin_homedir/.cache
%dir %attr(0750,%u7s_admin_usr,%u7s_admin_grp) %u7s_admin_homedir/.config
%dir %attr(0750,%u7s_admin_usr,%u7s_admin_grp) %u7s_admin_homedir/.ssh
%dir %attr(0750,%u7s_admin_usr,%u7s_admin_grp) %_localstatedir/podsec/u7s
%dir %attr(0750,%u7s_admin_usr,%u7s_admin_grp) %_localstatedir/podsec/u7s/etcd
%config(noreplace) %attr(0640,%u7s_admin_usr,%u7s_admin_grp) %u7s_admin_homedir/.bashrc
%config(noreplace) %attr(0640,%u7s_admin_usr,%u7s_admin_grp) %u7s_admin_homedir/.bash_profile
%config(noreplace) %attr(0640,%u7s_admin_usr,%u7s_admin_grp) %u7s_admin_homedir/.bash_logout

%files k8s-rbac
%_bindir/podsec-k8s-rbac-*
%_mandir/man?/podsec-k8s-rbac-*

%files inotify
%_bindir/podsec-inotify-*
%_mandir/man?/podsec-inotify-*
%_unitdir/podsec-inotify-*
%exclude %_unitdir/u7s.service

%files dev
%_bindir/podsec-save-oci
%_bindir/podsec-k8s-save-oci
%_mandir/man?/podsec-k8s-save-oci*
%_mandir/man?/podsec-save-oci*


%files icinga
%doc podsec-inotify/monitoring/podsec-icinga2.json
%config(noreplace) %_sysconfdir/icinga2/conf.d/podsec.conf

%files nagios
%config(noreplace) %_sysconfdir/nagios/templates/podsec-services.cfg
%config(noreplace) %_sysconfdir/nagios/nrpe-commands/podsec-commands.cfg

%changelog
