%def_enable snapshot

%define ver_major 46
%define beta %nil
%define xdg_name org.gnome.Polari

%def_enable check

Name: polari
Version: %ver_major.0
Release: alt3%beta

Summary: Internet Relay Chat client for GNOME
License: GPL-2.0 and LGPL-2.0
Group: Networking/Chat
Url: https://wiki.gnome.org/Apps/Polari

Vcs: https://github.com/GNOME/polari.git

%if_disabled snapshot
#Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
Source: https://github.com/GNOME/polari/archive/%version/%name-%version%beta.tar.gz
%else
Source: %name-%version.tar
%endif

%define gtk4_ver 4.10.0
%define gjs_ver 1.73.1
%define adw_ver 1.5

Requires: libgjs >= %gjs_ver
Requires: telepathy-mission-control
Requires: telepathy-idle
Requires: tinysparql localsearch

%set_typelibdir %_libdir/%name/girepository-1.0

Requires: typelib(Adw) = 1
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GObject)
Requires: typelib(Graphene)
Requires: typelib(Gtk) = 4.0
Requires: typelib(Pango)
Requires: typelib(PangoCairo)
Requires: typelib(Polari)
Requires: typelib(Secret)
Requires: typelib(TelepathyGLib)
Requires: typelib(Tracker) = 3.0
Requires: typelib(Soup) = 3.0

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson gtk-doc yelp-tools
BuildRequires: libgjs-devel >= %gjs_ver
BuildRequires: libgtk4-devel >= %gtk4_ver libtelepathy-glib-devel
BuildRequires: pkgconfig(tracker-sparql-3.0)
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libsoup3.0-gir-devel
BuildRequires: libsecret-gir-devel gir(Tracker) = 3.0
BuildRequires: libtelepathy-glib-gir-devel
%{?_enable_check:BuildRequires: desktop-file-utils /usr/bin/appstreamcli}

%description
Polari is a simple IRC Client that is designed to integrate seamlessly
with GNOME 3 Desktop.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %xdg_name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_iconsdir/hicolor/scalable/apps/%{xdg_name}*.svg
%_datadir/%name/
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Polari.service
%_datadir/telepathy/clients/Polari.client
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS


%changelog
