%define pg_ver 15
%ifarch loongarch64
# XXX: PostgreSQL jit relies on LLVM versions <= 15 (due to typed pointers).
# LoongArch targets are supported by LLVM versions >= 16.
%def_without jit
%else
%def_with jit
%endif

Name: postgresql%pg_ver-pg_partman
Version: 5.2.4
Release: alt1

Summary: pg_partman is an extension to create and manage both time-based and serial-based table partition sets.
License: PostgreSQL
Group: Databases
Url: https://badge.fury.io/pg/pg_partman

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-build-python3

# Automatically added by buildreq on Sat May 18 2019
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 python-base sh4
BuildRequires: postgresql%pg_ver-server-devel

Requires: postgresql%pg_ver-server

%description
pg_partman is an extension to create and manage both time-based and number-based table
partition sets. As of version 5.0.0, only built-in, declarative partitioning is
supported and the older trigger-based methods have been deprecated.

The declarative partitioning built into PostgreSQL provides the commands to create
a partitioned table and its children. pg_partman uses the built-in declarative features
that PostgreSQL provides and builds upon those with additional features and enhancements
to make managing partitions easier. One key way that pg_partman extends partitioning in
Postgres is by providing a means to automate the child table maintenance over time (Ex.
adding new children, dropping old ones based on a retention policy). pg_partman also has
features to turn an existing table into a partitioned table or vice versa.

%prep
%setup
%patch0 -p1

## py2 -> py3
sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')
sed -i 's|#!/usr/bin/python|#!/usr/bin/python3|' \
    $(find ./ -name '*.py')
##

%build
%make

%install
%makeinstall_std

%files
%_bindir/*
%_libdir/pgsql/pg_partman_bgw.so
%if %pg_ver >= 11
%if_with jit
%_libdir/pgsql/bitcode/src/pg_partman_bgw*
%endif
%endif
%_datadir/pgsql/extension/*
%doc %_datadir/doc/postgresql/extension/*

%changelog
