Name: praat
Version: 6.4
Release: alt1

Summary: A program for speech analysis and synthesis
License: GPLv2
Group: Sound

Url: http://www.praat.org

# https://github.com/praat/praat.git
Source: %name-%version.tar.gz
Patch0: %name-6.0.46-gcc8-fix.patch

# PATCH-FIX-OPENSUSE praat-use_system_libs.patch -- replace some embedded libs with system ones
Patch1:         praat-use_system_libs.patch
# PATCH-FIX-OPENSUSE praat-no-return-in-nonvoid.patch -- make the compiler happy
Patch2:         praat-no-return-in-nonvoid.patch
# PATCH-FEATURE-OPENSUSE praat-allow-system-flags.patch badshah400@gmail.com -- Allow compilation and linker flags to incorporate appropriate env flags
Patch3:         praat-allow-system-flags.patch


Requires: fonts-bitmap-75dpi

# Automatically added by buildreq on Mon Aug 24 2020
# optimized out: fontconfig fontconfig-devel glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libharfbuzz-devel libpango-devel libstdc++-devel pkg-config python2-base sh4 xorg-proto-devel
BuildRequires: gcc-c++ libalsa-devel libgtk+2-devel libjack-devel libpulseaudio-devel libstdc++-devel-static libglpk-devel libopus-devel libopusfile-devel  libopusurl-devel

BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(gsl)
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  pkgconfig(jack)
BuildRequires:  pkgconfig(libpulse)
BuildRequires:  pkgconfig(ogg)
BuildRequires:  pkgconfig(opusfile)
BuildRequires:  pkgconfig(vorbis)
BuildRequires:  pkgconfig(vorbisfile)


%description
According to its authors, praat is "doing phonetics by computer".
Through its graphical interface, several speech analysis functionalities
are available: spectrograms, cochleograms, and pitch and formant
extraction.  Articulatory synthesis, as well as synthesis from pitch,
formant, and intensity are also available.  Other features are
segmentation, labelling using the phonetic alphabet, and computation
of statistics.  Praat is configurable and extensible through its own
scripting language and has provisions for communicating with other
programs.

* Make sure you have read the Intro from Praat's Help menu.
* If that does not help, use the Search button in Praat's manual window.
* Or consult the Frequently Asked Questions on the website.

Recommends: fonts-bitmap-100dpi fonts-bitmap-75dpi

%prep
%setup
#patch0 -p2
%patch1 -p1
%patch2 -p1
%patch3 -p1
#patch5 -p1

%build
cp -a makefiles/makefile.defs.linux.pulse makefile.defs


sed -e '/^CFLAGS/s/$/\ %{optflags}/' \
    -e '/^CXXFLAGS/s/$/\ %{optflags}/' \
    -e '/^CC/s/?=/=/' -e '/^CXX/s/?=/=/' \
    -e '/^LINK/s/?=/=/' -i makefile.defs

#    -e '/^CC/s/=/?=/' -e '/^CXX/s/=/?=/' \
#    -e '/^LINK/s/=/?=/' -i makefile.defs



%make_build

%install
install -pDm755 %name %buildroot%_bindir/%name

%files
%_bindir/*

# TODO:
# - FLAC/ and audio/ are patched
# - GSL/ *seems* just bundled?
# - watch file:
# version=3
#opts="uversionmangle=s/\.0?(\d+)/\.$1/g" \
#  http://www.fon.hum.uva.nl/praat/download_sources.html praat(\d)(\d)(\d+)_sources.tar.gz debian

%changelog
