%def_enable shared
%def_disable static
%def_enable nls

Name: progsreiserfs
%define lname lib%name
Version: 0.3.0.5
Release: alt5
Summary: Programs needed for manipulating reiserfs partitions
Summary(ru_RU.UTF-8): Программа для манипулирования разделами диска с reiserfs
Summary(uk_UA.UTF-8): Програми для маніпулювання розділами диску з reiserfs
License: GPL-2.0-or-later
Group: System/Configuration/Hardware
# Url: ftp://ftp.namesys.com/pub/libreiserfs/
Source: %name-%version.tar
Patch: %name-%version-m4.patch
Patch1: libreiserfs-0.3.0.5-gettext.patch
%{?_enable_shared:Requires: %lname = %version-%release}

BuildRequires: libuuid-devel

%description
%name is a package that allows you to create, destroy, resize and copy
reiserfs filesystem.

%description -l uk_UA.UTF-8
%name - пакет, який дозволє створювати, знищувати, змінювати розмір та
копіювати файлову систему reiserfs.

%description -l ru_RU.UTF-8
%name - пакет для создания, удаления, изменения рамера и копирования файловой системы reiserfs.

%if_enabled shared
%package -n %lname
Summary: Shared library for reiserfs utilities
Group: System/Libraries

%description -n %lname
This package includes the shared library needed to run %lname-based
software.
%endif


%package -n %lname-devel
Summary: Files required to compile software that uses %lname
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %version-%release

%description -n %lname-devel
This package includes the header files for %lname.


%if_enabled static
%package -n %lname-devel-static
Summary: Files required to compile statically linked software that uses %lname
Group: Development/C
Requires: %lname = %version-%release

%description -n %lname-devel-static
This package includes the libraries needed to statically link software with
%lname.
%endif

%prep
%setup -q
%patch -p1
%patch1 -p1
for f in mk tune; do
	sed -i -r "s/(${f}fs)\.(reiserfs)/\2.\1/g" doc/${f}fs.reiserfs.8
done
[ -e config.rpath ] || :> config.rpath


%build
%autoreconf -fisv
%configure \
	%{subst_enable shared} \
	%{subst_enable static} \
	%{subst_enable nls} \
	--enable-threads=posix \
	--enable-largefile \
	--disable-rpath \
	--with-gnu-ld
%make_build
gzip -9c ChangeLog > ChangeLog.gz


%install
%makeinstall_std
for f in mk tune; do
	mv %buildroot%_sbindir/{${f}fs.reiserfs,reiserfs.${f}fs}
	mv %buildroot%_man8dir/{${f}fs.reiserfs,reiserfs.${f}fs}.8
done


%files
%doc AUTHORS ChangeLog.* NEWS README THANKS
%_sbindir/*
%_man8dir/*


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%endif


%files -n %lname-devel
%{?_enable_shared:%_libdir/*.so}
%_includedir/*
%_datadir/aclocal/*


%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif


%changelog
