
%define oname blackbox_exporter
%global import_path github.com/prometheus/blackbox_exporter

%global _unpackaged_files_terminate_build 1

Name: prometheus-%oname
Version: 0.25.0
Release: alt1
Summary: Prometheus blackbox prober exporter

Group: Development/Other
License: Apache-2.0
Url: https://%import_path
Source: %name-%version.tar

Source2: %name.sysconfig
Source3: %name.init
Source4: %name.service

ExclusiveArch:  %go_arches
BuildRequires(pre): rpm-build-golang
#BuildRequires: promu
BuildRequires: /proc

Requires(pre): prometheus-common

%description
The blackbox exporter allows blackbox probing of endpoints over HTTP, HTTPS, DNS, TCP and ICMP.

%prep
%setup -q

%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export GOFLAGS="-mod=vendor"
%golang_prepare
#promu build
export BUILDTAGS="netgo"
export LDFLAGS="-X github.com/prometheus/common/version.Version=%version \
         -X github.com/prometheus/common/version.Revision=%release \
         -X github.com/prometheus/common/version.Branch=tarball \
         -X github.com/prometheus/common/version.BuildDate=$(date -u +%%Y%%m%%d)"

%golang_build .

%install
export BUILDDIR="$PWD/.gopath"
#export GOPATH="%go_path"
%golang_install
rm -rf -- %buildroot%_datadir
rm -rf -- %buildroot%go_root
mkdir -p %buildroot{%_bindir,%_initdir,%_unitdir,%_sysconfdir/{sysconfig,prometheus}}

#install -m0755 %oname %buildroot%_bindir/%oname
install -m0644 blackbox.yml %buildroot%_sysconfdir/prometheus/blackbox.yml
install -m0644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name
install -m0755 %SOURCE3 %buildroot%_initdir/%name
install -m0644 %SOURCE4 %buildroot%_unitdir/%name.service

%post
%post_service %name

%preun
%preun_service %name

%files
%doc LICENSE README.md CONFIGURATION.md example.yml
%_bindir/*
%_unitdir/%name.service
%_initdir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_sysconfdir/prometheus/blackbox.yml

%changelog
