%define _unpackaged_files_terminate_build 1
%set_perl_req_method relaxed

Name: pve-container
Summary: Proxmox VE Container management tool
Version: 5.2.6
Release: alt1
License: AGPL-3.0+
Group: System/Servers
Url: https://www.proxmox.com
Vcs: git://git.proxmox.com/git/pve-container.git
Source: %name-%version.tar

ExclusiveArch: x86_64 aarch64

Requires(pre,postun): shadow-submap
Requires: pve-lxc pve-lxc-syscalld pve-ha-manager >= 3.0.9 pve-access-control >= 8.0.0
Requires: proxmox-backup-client >= 3.2.3.1
Requires: dtach xz file binutils

BuildRequires: pve-common >= 8.1.0 pve-guest-common >= 5.1.0 pve-qemu-server pve-storage >= 8.3.5
BuildRequires: pve-firewall pve-cluster >= 4.0.8 libpve-cluster-perl pve-doc-generator xmlto pve-lxc >= 4.0.9
BuildRequires: pve-manager pve-ha-manager >= 3.0.9
BuildRequires: perl(Crypt/Eksblowfish/Bcrypt.pm) perl(UUID.pm)

%description
%summary.
Tool to manage Linux Containers on Proxmox VE.

%prep
%setup
sed -i 's!}/lib/systemd/!}/usr/lib/systemd/!' src/Makefile

%install
%makeinstall_std -C src

%post
%_sbindir/usermod --add-subgids 100000-165535 root ||:
%_sbindir/usermod --add-subuids 100000-165535 root ||:

%files
%doc debian/copyright
%_sysconfdir/apparmor.d/pve-container-mounthotplug
%_sysctldir/10-pve-ct-inotify-limits.conf
%_datadir/bash-completion/completions/*
%_datadir/zsh/vendor-completions/*
%_unitdir/*
%_sbindir/*
%_datadir/lxc
%perl_vendor_privlib/PVE/LXC
%perl_vendor_privlib/PVE/*.pm
%perl_vendor_privlib/PVE/API2/LXC
%perl_vendor_privlib/PVE/API2/*.pm
%perl_vendor_privlib/PVE/CLI/*.pm
%perl_vendor_privlib/PVE/VZDump/*.pm
%_man1dir/*
%_man5dir/*

%changelog
