%global _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

Name: pve-lxc-syscalld
Summary: PVE LXC syscall daemon
Version: 1.3.0
Release: alt2
License: AGPL-3.0+
Group: System/Servers
Url: https://git.proxmox.com/

Vcs: git://git.proxmox.com/git/pve-lxc-syscalld.git 
Source: %name-%version.tar
Patch: pve-lxc-syscalld-aarch64-u8.patch

ExclusiveArch: x86_64 aarch64
BuildRequires(pre): rpm-macros-rust rpm-macros-systemd
BuildRequires: rpm-build-rust libsystemd-devel
BuildRequires: /proc

%description
A daemon which handles a selected subset of syscalls for unprivileged
containers.

%prep
%setup
%ifarch aarch64
%patch -p0 -b .u8
%endif

%build
export BUILD_MODE=release
%make_build

%install
%makeinstall_std
install -dm755 %buildroot{%_unitdir,%_tmpfilesdir}
install -m644 etc/%name.service %buildroot%_unitdir/

cat << __EOF__ > %buildroot%_tmpfilesdir/%name.conf
d /run/pve 0755 root root
__EOF__

%post
%tmpfiles_create %_tmpfilesdir/%name.conf
%post_systemd_postponed %name

%preun
%preun_systemd %name

%files
%doc debian/copyright
%_unitdir/%name.service
%_tmpfilesdir/%name.conf
%_libexecdir/%name/%name

%changelog
